/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.BeIDCards;
import be.fedict.commons.eid.client.CancelledException;
import java.security.SecureRandomSpi;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDSecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDSecureRandom.class);
    private BeIDCard beIDCard;

    @Override
    protected void engineSetSeed(byte[] seed) {
        LOGGER.debug("engineSetSeed");
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        byte[] randomData;
        LOGGER.debug("engineNextBytes: {} bytes", (Object)bytes.length);
        BeIDCard beIDCard = this.getBeIDCard();
        try {
            try {
                randomData = beIDCard.getChallenge(bytes.length);
            }
            catch (Exception e) {
                beIDCard = this.getBeIDCard(true);
                randomData = beIDCard.getChallenge(bytes.length);
            }
        }
        catch (CardException e) {
            throw new RuntimeException(e);
        }
        System.arraycopy(randomData, 0, bytes, 0, bytes.length);
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] randomData;
        LOGGER.debug("engineGenerateSeed: {} bytes", (Object)numBytes);
        BeIDCard beIDCard = this.getBeIDCard();
        try {
            randomData = beIDCard.getChallenge(numBytes);
        }
        catch (CardException e) {
            throw new RuntimeException(e);
        }
        return randomData;
    }

    private BeIDCard getBeIDCard(boolean autoRecover) {
        if (autoRecover) {
            this.beIDCard = null;
        }
        return this.getBeIDCard();
    }

    private BeIDCard getBeIDCard() {
        if (null != this.beIDCard) {
            return this.beIDCard;
        }
        BeIDCards beIDCards = new BeIDCards();
        try {
            this.beIDCard = beIDCards.getOneBeIDCard();
        }
        catch (CancelledException e) {
            throw new RuntimeException(e);
        }
        return this.beIDCard;
    }
}

