/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.eid;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.BeIDCards;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.spi.BeIDCardUI;
import be.fedict.commons.eid.client.spi.BeIDCardsUI;
import be.fedict.commons.eid.client.spi.Logger;
import be.fedict.commons.eid.dialogs.DefaultBeIDCardsUI;
import be.fedict.commons.eid.dialogs.Messages;
import be.fedict.commons.eid.jca.BeIDKeyStoreParameter;
import be.fgov.ehealth.etee.crypto.eid.EidLogger;
import be.fgov.ehealth.etee.crypto.eid.EidSmartCardReader;
import be.fgov.ehealth.etee.crypto.eid.FedictConfiguration;
import be.fgov.ehealth.etee.crypto.eid.exception.NoAvailableSmartCardException;
import be.fgov.ehealth.etee.crypto.eid.exception.SmartCardReaderException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Locale;
import javax.smartcardio.CardException;
import javax.smartcardio.TerminalFactory;

class FedictEidSmartCardReader
implements EidSmartCardReader {
    private static final int HALF_A_SECOND = 500;
    public static final Provider BE_ID_PROVIDER = FedictConfiguration.getBeIDProvider();

    FedictEidSmartCardReader() {
    }

    @Override
    public boolean isReaderPresent() throws SmartCardReaderException {
        TerminalFactory terminalFactory = TerminalFactory.getDefault();
        try {
            return !terminalFactory.terminals().list().isEmpty();
        }
        catch (CardException cardException) {
            throw new SmartCardReaderException(cardException);
        }
    }

    @Override
    public boolean isEidCardPresent() throws SmartCardReaderException {
        BeIDCards beIDCards = new BeIDCards();
        return beIDCards.hasBeIDCards();
    }

    @Override
    public KeyStore readKeyStore(BeIDCardUI userInterface) throws SmartCardReaderException, NoAvailableSmartCardException {
        if (userInterface == null) {
            throw new SmartCardReaderException("There must be an BeIDCardUI extension provided to be able to get the password for the card reader");
        }
        try {
            BeIDCard beIDCard = this.buildBeIDCard(userInterface);
            KeyStore beIDStore = this.buildBeIDStore();
            beIDStore.load((KeyStore.LoadStoreParameter)this.buildBeIDStoreParams(beIDCard));
            return beIDStore;
        }
        catch (IOException ioException) {
            throw new SmartCardReaderException(ioException);
        }
        catch (NoSuchAlgorithmException smartCardException) {
            throw new SmartCardReaderException(smartCardException);
        }
        catch (CertificateException certificateException) {
            throw new SmartCardReaderException(certificateException);
        }
    }

    @Override
    public boolean waitForCardReader(long timeout) throws SmartCardReaderException {
        boolean stop = false;
        long startTime = System.currentTimeMillis();
        TerminalFactory terminalFactory = TerminalFactory.getDefault();
        try {
            while (!stop) {
                if (!terminalFactory.terminals().list().isEmpty()) {
                    return true;
                }
                if (System.currentTimeMillis() - startTime > timeout) {
                    stop = true;
                    continue;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            throw new SmartCardReaderException(e);
        }
        catch (CardException e) {
            throw new SmartCardReaderException(e);
        }
        return false;
    }

    @Override
    public boolean waitForCard(long timeout) throws SmartCardReaderException {
        BeIDCards beIDCards = new BeIDCards();
        boolean stop = false;
        long startTime = System.currentTimeMillis();
        try {
            while (!stop) {
                if (beIDCards.hasBeIDCards()) {
                    return true;
                }
                if (System.currentTimeMillis() - startTime > timeout) {
                    stop = true;
                    continue;
                }
                Thread.sleep(500L);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            throw new SmartCardReaderException(interruptedException);
        }
    }

    private BeIDKeyStoreParameter buildBeIDStoreParams(BeIDCard beIDCard) {
        BeIDKeyStoreParameter keyStoreParameter = new BeIDKeyStoreParameter();
        keyStoreParameter.setAutoRecovery(true);
        keyStoreParameter.setBeIDCard(beIDCard);
        return keyStoreParameter;
    }

    private KeyStore buildBeIDStore() throws SmartCardReaderException {
        try {
            return KeyStore.getInstance("BeID", BE_ID_PROVIDER);
        }
        catch (KeyStoreException e) {
            throw new SmartCardReaderException("Keystore for Belgian eID could not be built.", e);
        }
    }

    private BeIDCard buildBeIDCard(BeIDCardUI userInterface) throws NoAvailableSmartCardException, SmartCardReaderException {
        Messages messages = Messages.getInstance((Locale)Locale.getDefault());
        DefaultBeIDCardsUI ui = new DefaultBeIDCardsUI(null, messages);
        BeIDCards beIDCards = new BeIDCards((Logger)EidLogger.forClass(BeIDCards.class), (BeIDCardsUI)ui);
        if (!beIDCards.hasBeIDCards()) {
            throw new NoAvailableSmartCardException("missing eID card");
        }
        try {
            BeIDCard beIDCard = beIDCards.getOneBeIDCard();
            beIDCard.setUI(userInterface);
            return beIDCard;
        }
        catch (CancelledException e) {
            throw new SmartCardReaderException("user cancelled", e);
        }
    }
}

