/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.eid.utils;

import be.fgov.ehealth.etee.crypto.eid.utils.ProviderFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class SecurityConfiguration {
    public static final String DEFAULT_PROVIDER_NAME = "BeIDProvider";
    public static final String DEFAULT_PROVIDER_NOT_CONFIGURED = "The default security provider hasn't been configured yet. Please execute SecurityConfiguration.configure()";

    private SecurityConfiguration() {
    }

    public static Provider getEIDProvider() {
        Provider provider = Security.getProvider(DEFAULT_PROVIDER_NAME);
        if (provider == null) {
            throw new SecurityException(DEFAULT_PROVIDER_NOT_CONFIGURED);
        }
        return provider;
    }

    public static void configure() {
        if (Security.getProvider(DEFAULT_PROVIDER_NAME) == null) {
            Optional<Provider> sunEC = Optional.ofNullable(Security.getProvider("SunEC"));
            sunEC.ifPresent(provider -> Security.removeProvider("SunEC"));
            Security.addProvider(ProviderFactory.createDefaultProvider());
            Security.addProvider((Provider)new BouncyCastleProvider());
            sunEC.ifPresent(Security::addProvider);
        }
    }
}

