/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.resolvers;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentResolver
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentResolver.class);
    private Map<String, Document> documents = new HashMap<String, Document>();

    public DocumentResolver(String baseURI, Document doc) {
        this.documents.put(baseURI, doc);
    }

    public void addDocument(String baseURI, Document doc) {
        this.documents.put(baseURI, doc);
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        String id = uri.getNodeValue();
        if (id.startsWith("#")) {
            id = uri.getNodeValue().substring(1);
        }
        if (this.documents.containsKey(id) || this.documents.size() == 1) {
            LOG.debug("Can resolve attribute with id [" + id + "]");
            return true;
        }
        LOG.debug("Unable resolve attribute with id [" + id + "]");
        return false;
    }

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        Element selectedElem = null;
        String id = uri.getNodeValue();
        if (id.startsWith("#")) {
            id = uri.getNodeValue().substring(1);
        }
        Document selectedDoc = null;
        selectedDoc = this.documents.containsKey(id) ? this.documents.get(id) : this.documents.values().toArray(new Document[0])[0];
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Selected document: " + ConnectorXmlUtils.flatten((String)ConnectorXmlUtils.toString((Source)new DOMSource(selectedDoc))));
            }
            catch (TechnicalConnectorException e) {
                LOG.error(e.getMessage());
            }
        }
        this.flagAttributeValueAsId(selectedDoc.getDocumentElement(), id);
        selectedElem = selectedDoc.getElementById(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to catch an Element with ID " + id + " and Element was " + selectedElem);
        }
        this.processElement(uri, baseURI, selectedElem, id);
        XMLSignatureInput result = new XMLSignatureInput((Node)selectedElem);
        result.setExcludeComments(true);
        result.setMIMEType("text/xml");
        result.setSourceURI(baseURI != null ? baseURI.concat(uri.getNodeValue()) : uri.getNodeValue());
        return result;
    }

    private void processElement(Attr uri, String baseURI, Node selectedElem, String id) throws ResourceResolverException {
        if (selectedElem == null) {
            Object[] exArgs = new Object[]{id};
            throw new ResourceResolverException("signature.Verification.MissingID", exArgs, uri, baseURI);
        }
    }

    private void flagAttributeValueAsId(Element el, String attrValue) {
        boolean foundAttr = false;
        NamedNodeMap attrMap = el.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node item = attrMap.item(i);
            if (!item.getTextContent().equalsIgnoreCase(attrValue)) continue;
            el.setIdAttribute(item.getLocalName(), true);
            foundAttr = true;
            break;
        }
        if (!foundAttr) {
            NodeList childs = el.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 1) continue;
                this.flagAttributeValueAsId((Element)childs.item(i), attrValue);
            }
        }
    }
}

