/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.resolvers;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.signature.impl.DomUtils;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLAssertionKeyResolver
extends KeyResolverSpi {
    private static final String ATTR_VALUE_SAML_1_1_PROFILE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    private static final String ATTR_VALUE_ASSERTION_ID = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    private static final String XMLNS_SAML = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String XMLNS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final Logger LOG = LoggerFactory.getLogger(SAMLAssertionKeyResolver.class);
    private static final CertificateFactory CF;

    public boolean engineCanResolve(Element sigElement, String baseURI, StorageResolver storage) {
        return this.extract(sigElement) != null;
    }

    public Node extract(Element sigElement) {
        String securityTokenReferenceTokenType;
        Element securityTokenReference = null;
        if ("SecurityTokenReference".equals(sigElement.getLocalName()) && XMLNS_WSSE.equals(sigElement.getNamespaceURI())) {
            securityTokenReference = sigElement;
        } else {
            NodeList securityTokenReferenceList = DomUtils.getMatchingChilds(sigElement, XMLNS_WSSE, "SecurityTokenReference");
            if (securityTokenReferenceList.getLength() == 1) {
                securityTokenReference = (Element)securityTokenReferenceList.item(0);
            }
        }
        if (securityTokenReference != null && ATTR_VALUE_SAML_1_1_PROFILE.equals(securityTokenReferenceTokenType = securityTokenReference.getAttributes().getNamedItemNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType").getTextContent())) {
            NodeList keyIdentifierList = DomUtils.getMatchingChilds(securityTokenReference, XMLNS_WSSE, "KeyIdentifier");
            for (int j = 0; j < keyIdentifierList.getLength(); ++j) {
                Node keyIdentifier = keyIdentifierList.item(j);
                String keyIdentifierValueType = keyIdentifier.getAttributes().getNamedItem("ValueType").getTextContent();
                if (!ATTR_VALUE_ASSERTION_ID.equals(keyIdentifierValueType)) continue;
                LOG.debug("SAML1.1 assertion detected.");
                return keyIdentifier;
            }
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element sigElement, String baseURI, StorageResolver storage) throws KeyResolverException {
        Node keyIdentifier = this.extract(sigElement);
        String samlAssertionId = keyIdentifier.getTextContent();
        NodeList samlAssertionList = sigElement.getOwnerDocument().getElementsByTagNameNS(XMLNS_SAML, "Assertion");
        for (int k = 0; k < samlAssertionList.getLength(); ++k) {
            Element samlAssertion = (Element)samlAssertionList.item(k);
            if (!samlAssertionId.equals(samlAssertion.getAttributes().getNamedItem("AssertionID").getTextContent())) continue;
            NodeList authenticationStatements = DomUtils.getMatchingChilds(samlAssertion, XMLNS_SAML, "AuthenticationStatement");
            if (authenticationStatements.getLength() > 1) {
                LOG.debug("Multiple AuthenticationStatements found;");
                return null;
            }
            NodeList x509CertificateList = DomUtils.getMatchingChilds(authenticationStatements.item(0), "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            for (int l = 0; l < x509CertificateList.getLength(); ++l) {
                certList.add(this.generate(x509CertificateList.item(l).getTextContent()));
            }
            LOG.debug("X509Certificate(s) detected in AuthenticationStatement [" + certList.size() + "];");
            try {
                X509Certificate x509Certificate = (X509Certificate)CF.generateCertPath(certList).getCertificates().get(0);
                LOG.debug("returning  X509Certificate [" + x509Certificate.getSubjectX500Principal().getName("RFC1779"));
                return x509Certificate;
            }
            catch (CertificateException e) {
                LOG.error("", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate generate(String keyVale) {
        X509Certificate x509Certificate;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(Base64.decode((byte[])keyVale.getBytes()));
            x509Certificate = (X509Certificate)CF.generateCertificate(in);
        }
        catch (Exception e) {
            X509Certificate x509Certificate2;
            try {
                LOG.error("Error while generating certificate.", (Throwable)e);
                x509Certificate2 = null;
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in);
                throw throwable;
            }
            ConnectorIOUtils.closeQuietly((Object)in);
            return x509Certificate2;
        }
        ConnectorIOUtils.closeQuietly((Object)in);
        return x509Certificate;
    }

    static {
        try {
            CF = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

