/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.services.schematron.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.schematron.SchematronSession;
import be.fgov.ehealth.schematron.SchematronSessionFactory;
import be.fgov.ehealth.schematron.domain.SchematronConfig;
import be.fgov.ehealth.schematron.domain.SchematronResult;
import be.fgov.ehealth.schematron.exception.InitialisationException;
import be.fgov.ehealth.technicalconnector.services.schematron.SchematronValidationResult;
import be.fgov.ehealth.technicalconnector.services.schematron.SchematronValidator;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.oclc.purl.dsdl.svrl.SchematronOutput;

public class SchematronValidatorImpl
implements SchematronValidator {
    @Override
    public SchematronValidationResult validate(String inputLocation, String schematronLocation) throws TechnicalConnectorException, InitialisationException {
        return this.validate(ConnectorIOUtils.getResourceAsStream((String)inputLocation), ConnectorIOUtils.getResourceAsStream((String)schematronLocation));
    }

    @Override
    public SchematronValidationResult validate(InputStream input, InputStream schematron) throws TechnicalConnectorException, InitialisationException {
        SchematronConfig config = new SchematronConfig();
        config.setQueryLanguageBinding("xslt2");
        config.setSchema(schematron);
        config.setDebugMode(true);
        SchematronSession session = SchematronSessionFactory.newInstance((SchematronConfig)config);
        try {
            SchematronSessionFactory.initSaxon();
            SchematronResult result = session.validate(input);
            SchematronSessionFactory.stopSaxon();
            return new SchematronValidationResultImpl(result);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[0]);
        }
    }

    private static class SchematronValidationResultImpl
    implements SchematronValidationResult {
        private SchematronResult result;

        public SchematronValidationResultImpl(SchematronResult result) {
            this.result = result;
        }

        @Override
        public boolean isValid() {
            return this.result.isValid();
        }

        @Override
        public String[] getReportMessages() {
            return this.result.getReportMessages();
        }

        @Override
        public String[] getFailedMessages() {
            return this.result.getFailedMessages();
        }

        @Override
        public SchematronOutput getSVRL() throws TechnicalConnectorException {
            try {
                return this.result.getSVRL();
            }
            catch (JAXBException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[0]);
            }
        }

        @Override
        public String getSVRLAsString() {
            return this.result.getSVRLAsString();
        }
    }
}

