/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.domain;

import be.ehealth.technicalconnector.beid.BeIDFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.ra.domain.Actor;
import be.fgov.ehealth.technicalconnector.ra.domain.ContactData;
import be.fgov.ehealth.technicalconnector.ra.domain.GeneratedContract;
import be.fgov.ehealth.technicalconnector.ra.domain.LocalizedText;
import be.fgov.ehealth.technicalconnector.ra.domain.Request;
import be.fgov.ehealth.technicalconnector.ra.enumaration.UsageType;
import be.fgov.ehealth.technicalconnector.ra.utils.CertificateUtils;
import be.fgov.ehealth.technicalconnector.ra.utils.RaPropertiesLoader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class NewCertificateContract
extends Request {
    private static final long serialVersionUID = 1L;
    private String dn;
    private ContactData contact;
    private byte[] pkcs10;
    private LocalizedText text;
    private List<UsageType> usageTypes = new ArrayList<UsageType>();
    private Actor signer;

    public NewCertificateContract(GeneratedContract generatedContract, KeyPair keyPair, List<UsageType> usageTypes) throws TechnicalConnectorException {
        super(BeIDFactory.getBeIDInfo((String)"requestor", (boolean)false).getIdentity());
        Validate.notNull((Object)generatedContract);
        Validate.isTrue((boolean)generatedContract.isContractViewed());
        Validate.notEmpty((CharSequence)generatedContract.getDN());
        Validate.notNull((Object)generatedContract.getSigner());
        Validate.notNull((Object)generatedContract.getContactData());
        Validate.notNull((Object)generatedContract.getIdentifierType());
        Validate.notNull((Object)keyPair);
        this.contact = generatedContract.getContactData();
        this.dn = generatedContract.getDN().replace(generatedContract.getIdentifierType().getType(48) + "=", generatedContract.getIdentifierType().getType(48) + "\\=");
        this.text = generatedContract.getText();
        this.usageTypes = usageTypes;
        this.signer = generatedContract.getSigner();
        this.pkcs10 = CertificateUtils.createCSR(generatedContract.getDN(), keyPair);
        this.verifyPKCS10(this.pkcs10, this.dn);
    }

    public ContactData getContact() {
        return this.contact;
    }

    public byte[] getPkcs10DerEncoded() {
        return ArrayUtils.clone((byte[])this.pkcs10);
    }

    public String getDn() {
        return this.dn;
    }

    public List<UsageType> getUsageTypes() {
        return this.usageTypes;
    }

    public Actor getSigner() {
        return this.signer;
    }

    public LocalizedText getText() {
        return this.text;
    }

    private void verifyPKCS10(byte[] pkcs10, String dn) {
        PKCS10CertificationRequest csr;
        Validate.notNull((Object)pkcs10);
        try {
            csr = new PKCS10CertificationRequest(pkcs10);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        SubjectPublicKeyInfo pkInfo = csr.getSubjectPublicKeyInfo();
        Validate.isTrue((boolean)RaPropertiesLoader.getProperty("authentication.key.algorithm.oid").equals(pkInfo.getAlgorithm().getAlgorithm().getId()), (String)"Public key was not RSA.", (Object[])new Object[0]);
        Validate.isTrue((this.getKeySize(pkInfo) >= Integer.parseInt(RaPropertiesLoader.getProperty("authentication.key.size")) ? 1 : 0) != 0);
        X500Name subject = csr.getSubject();
        X500Name calculatedSubject = new X500Name(dn);
        Validate.isTrue((boolean)subject.equals((Object)calculatedSubject));
    }

    private int getKeySize(SubjectPublicKeyInfo subjectPKInfo) {
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString(subjectPKInfo.getEncoded()).getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithm();
            PublicKey publicKey = KeyFactory.getInstance(keyAlg.getAlgorithm().getId()).generatePublic(xspec);
            String algorithm = publicKey.getAlgorithm();
            KeyFactory keyFact = KeyFactory.getInstance(algorithm);
            RSAPublicKeySpec keySpec = keyFact.getKeySpec(publicKey, RSAPublicKeySpec.class);
            BigInteger modulus = keySpec.getModulus();
            return modulus.toString(2).length();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewCertificateContract that = (NewCertificateContract)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getDn(), (Object)that.getDn()).append((Object)this.getContact(), (Object)that.getContact()).append(this.pkcs10, that.pkcs10).append((Object)this.getText(), (Object)that.getText()).append(this.getUsageTypes(), that.getUsageTypes()).append((Object)this.getSigner(), (Object)that.getSigner()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getDn()).append((Object)this.getContact()).append(this.pkcs10).append((Object)this.getText()).append(this.getUsageTypes()).append((Object)this.getSigner()).toHashCode();
    }
}

