/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.builders;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.technicalconnector.ra.domain.Actor;
import be.fgov.ehealth.technicalconnector.ra.domain.ActorId;
import be.fgov.ehealth.technicalconnector.ra.domain.CertificateIdentifier;
import be.fgov.ehealth.technicalconnector.ra.domain.ContactData;
import be.fgov.ehealth.technicalconnector.ra.domain.ContractRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.Organization;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public final class ContractRequestBuilder {
    private ContractRequestBuilder() {
        throw new UnsupportedOperationException();
    }

    private static class BasicSteps
    implements InitStep,
    OrganizationChoiceStep1,
    OrganizationChoiceStep2,
    OrganizationChoiceStep3,
    ContactDataStep,
    ContactDataStep0,
    ContactDataStep1,
    ContactDataStep2,
    ContactDataStep3,
    BuildStep {
        private String personalEmail;
        private String personalPhone;
        private String generalEmail;
        private String generalPhone;
        private String organizationName;
        private IdentifierType organizationIdentifier;
        private String organizationId;
        private Identity requestor = BeIDInfo.getInstance().getIdentity();
        private CertificateIdentifier certificateIdentifier;
        Actor signer = Actor.newBuilder().firstNames(Arrays.asList(this.requestor.getFirstName())).name(this.requestor.getName()).ids(Arrays.asList(ActorId.newBuilder().type(IdentifierType.SSIN.getType(48)).value(this.requestor.getNationalNumber()).build())).build();

        @Override
        public ContactDataStep withEid() {
            this.certificateIdentifier = CertificateIdentifier.newBuilder().actor(this.signer).build();
            return this;
        }

        @Override
        public OrganizationChoiceStep1 forOrganization() {
            return this;
        }

        @Override
        public OrganizationChoiceStep3 forOrganization(Organization organization) {
            this.withId(organization.getId(), organization.getType());
            this.withName(organization.getName());
            return this;
        }

        @Override
        public ContactDataStep withApplicationId(String applicationId) {
            Validate.notEmpty((String)applicationId);
            this.buildCertificateIdentifier(applicationId);
            return this;
        }

        @Override
        public ContactDataStep withoutApplicationId() {
            this.buildCertificateIdentifier(null);
            return this;
        }

        public void buildCertificateIdentifier(String applicationId) {
            this.certificateIdentifier = CertificateIdentifier.newBuilder().actor(Actor.newBuilder().firstNames(Arrays.asList(this.requestor.getFirstName())).name(this.organizationName).ids(Arrays.asList(ActorId.newBuilder().type(this.organizationIdentifier.getType(48)).value(this.organizationId).build())).build()).applicationId(applicationId).build();
        }

        @Override
        public OrganizationChoiceStep3 withName(String name) {
            Validate.notEmpty((String)name);
            this.organizationName = name;
            return this;
        }

        @Override
        public OrganizationChoiceStep2 withId(String id, IdentifierType type) {
            Validate.notEmpty((String)id);
            Validate.notNull((Object)type);
            this.organizationId = id;
            this.organizationIdentifier = type;
            return this;
        }

        @Override
        public BuildStep withContact(ContactData contactData) {
            this.withPrivatePhone(contactData.getPhonePrivate());
            this.withPrivateEmail(contactData.getEmailPrivate());
            this.withGeneralPhone(contactData.getPhoneGeneral());
            this.withGeneralEmail(contactData.getEmailGeneral());
            return this;
        }

        @Override
        public ContactDataStep0 forContact() {
            return this;
        }

        @Override
        public ContactDataStep1 withPrivatePhone(String phone) {
            Validate.notEmpty((String)phone);
            this.personalPhone = phone;
            return this;
        }

        @Override
        public ContactDataStep2 withPrivateEmail(String mail) {
            Validate.notEmpty((String)mail);
            this.personalEmail = mail;
            return this;
        }

        @Override
        public ContactDataStep3 withGeneralPhone(String phone) {
            this.generalPhone = phone;
            return this;
        }

        @Override
        public BuildStep withGeneralEmail(String mail) {
            this.generalEmail = mail;
            return this;
        }

        @Override
        public ContractRequest build() throws TechnicalConnectorException {
            return ContractRequest.newBuilder().signer(this.signer).contactData(new ContactData(this.generalPhone, this.personalPhone, this.generalEmail, this.personalEmail)).certificateIdentifier(this.certificateIdentifier).build();
        }
    }

    public static interface BuildStep {
        public ContractRequest build() throws TechnicalConnectorException;
    }

    public static interface ContactDataStep3 {
        public BuildStep withGeneralEmail(String var1);
    }

    public static interface ContactDataStep2 {
        public ContactDataStep3 withGeneralPhone(String var1);
    }

    public static interface ContactDataStep1 {
        public ContactDataStep2 withPrivateEmail(String var1);
    }

    public static interface ContactDataStep0 {
        public ContactDataStep1 withPrivatePhone(String var1);
    }

    public static interface ContactDataStep {
        public BuildStep withContact(ContactData var1);

        public ContactDataStep0 forContact();
    }

    public static interface OrganizationChoiceStep3 {
        public ContactDataStep withoutApplicationId();

        public ContactDataStep withApplicationId(String var1);
    }

    public static interface OrganizationChoiceStep2 {
        public OrganizationChoiceStep3 withName(String var1);
    }

    public static interface OrganizationChoiceStep1 {
        public OrganizationChoiceStep2 withId(String var1, IdentifierType var2);
    }

    public static interface InitStep {
        public ContactDataStep withEid();

        public OrganizationChoiceStep1 forOrganization();

        public OrganizationChoiceStep3 forOrganization(Organization var1);
    }

    static class ContractRequestSteps
    implements ContractRequestBuilderStep {
        ContractRequestSteps() {
        }

        @Override
        public InitStep create() throws TechnicalConnectorException {
            return new BasicSteps();
        }
    }

    public static interface ContractRequestBuilderStep {
        public InitStep create() throws TechnicalConnectorException;
    }
}

