/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.builders;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.ra.domain.Organization;
import be.fgov.ehealth.technicalconnector.ra.service.AuthenticationCertificateRegistrationService;
import be.fgov.ehealth.technicalconnector.ra.service.ServiceFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public final class InformationBuilder {
    private InformationBuilder() {
        throw new UnsupportedOperationException();
    }

    private static class InnerChoiceIdentityRCStep
    extends AbstractInnerChoiceStep
    implements IdentityChoiceRCStep {
        private InnerChoiceIdentityRCStep() {
        }

        @Override
        public List<X509Certificate> forCurrentIdentity() {
            try {
                Identity identity = BeIDInfo.getInstance().getIdentity();
                return this.service.getRevokableCertificates(identity).getResult();
            }
            catch (TechnicalConnectorException e) {
                return new ArrayList<X509Certificate>();
            }
        }
    }

    private static class InnerChoiceIdentityAOStep
    extends AbstractInnerChoiceStep
    implements IdentityChoiceAOStep {
        private InnerChoiceIdentityAOStep() {
        }

        @Override
        public List<Organization> forCurrentIdentity() {
            try {
                Identity identity = BeIDInfo.getInstance().getIdentity();
                return this.service.getOrganizationList(identity).getResult();
            }
            catch (TechnicalConnectorException e) {
                return new ArrayList<Organization>();
            }
        }
    }

    private static class InnerChoiceOrganizationStep
    extends AbstractInnerChoiceStep
    implements OrganizationChoiceStep {
        private InnerChoiceOrganizationStep() {
        }

        @Override
        public List<String> forOrganization(Organization org) {
            try {
                return this.service.getApplicationIdList(org).getResult();
            }
            catch (TechnicalConnectorException e) {
                return new ArrayList<String>();
            }
        }
    }

    private static abstract class AbstractInnerChoiceStep {
        protected AuthenticationCertificateRegistrationService service;

        public AbstractInnerChoiceStep() {
            try {
                this.service = ServiceFactory.getAuthenticationCertificateRegistrationService();
            }
            catch (TechnicalConnectorException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static class InformationBuilderSteps
    implements InformationBuilderStep {
        InformationBuilderSteps() {
        }

        @Override
        public OrganizationChoiceStep listActiveApplicationIds() {
            return new InnerChoiceOrganizationStep();
        }

        @Override
        public IdentityChoiceAOStep listAssociatedOrganizations() {
            return new InnerChoiceIdentityAOStep();
        }

        @Override
        public IdentityChoiceRCStep listRevocableCertificates() {
            return new InnerChoiceIdentityRCStep();
        }
    }

    public static interface IdentityChoiceRCStep {
        public List<X509Certificate> forCurrentIdentity();
    }

    public static interface IdentityChoiceAOStep {
        public List<Organization> forCurrentIdentity();
    }

    public static interface OrganizationChoiceStep {
        public List<String> forOrganization(Organization var1);
    }

    public static interface InformationBuilderStep {
        public OrganizationChoiceStep listActiveApplicationIds();

        public IdentityChoiceAOStep listAssociatedOrganizations();

        public IdentityChoiceRCStep listRevocableCertificates();
    }
}

