/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.domain;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.CertificateParser;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.technicalconnector.ra.domain.Organization;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistinguishedName
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DistinguishedName.class);
    private static final long serialVersionUID = 1L;
    private static final Pattern APPLICATIONID_PATTERN = Pattern.compile("[0-9A-Z-_]{1,30}");
    private String id;
    private String name;
    private IdentifierType type;
    private String applicationId;
    private static Identity identity;
    private static String basename;

    public DistinguishedName() throws TechnicalConnectorException {
        this(DistinguishedName.getIdentity().getNationalNumber(), DistinguishedName.getIdentity().getFirstName() + " " + DistinguishedName.getIdentity().getName(), IdentifierType.SSIN, null);
        identity = null;
    }

    public DistinguishedName(X500Principal principal) throws TechnicalConnectorException {
        CertificateParser parser = new CertificateParser(principal.getName("RFC2253"));
        this.setId(parser.getId());
        this.setType(parser.getIdentifier());
        this.setApplicationId(parser.getApplication());
        try {
            List<Rdn> rdns = new LdapName(principal.getName("RFC1779")).getRdns();
            for (Rdn rdn : rdns) {
                String value;
                if (!rdn.getType().equals("OU") || "eHealth-platform Belgium".equals(value = this.getValue(rdn.getValue())) || value.contains("=")) continue;
                this.setName(this.getValue(rdn.getValue()));
                break;
            }
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException("Invalid Principal", e);
        }
    }

    public DistinguishedName(Organization org) {
        this(org, null);
    }

    public DistinguishedName(Organization org, String applicationId) {
        this(DistinguishedName.notNull(org).getId(), DistinguishedName.notNull(org).getName(), DistinguishedName.notNull(org.getType()), applicationId);
    }

    private DistinguishedName(String id, String name, IdentifierType type, String applicationId) {
        this.setId(id);
        this.setName(name);
        this.setApplicationId(applicationId);
        this.setType(type);
    }

    private void setId(String id) {
        Validate.notEmpty((String)id);
        this.id = id;
    }

    private void setName(String name) {
        Validate.notEmpty((String)name);
        this.name = DistinguishedName.normalize(name);
    }

    public void setApplicationId(String applicationId) {
        this.isValidApplicationId(DistinguishedName.normalize(applicationId));
        this.applicationId = DistinguishedName.normalize(applicationId);
    }

    private void setType(IdentifierType type) {
        Validate.notNull((Object)type);
        this.type = type;
    }

    private void isValidApplicationId(String applicationId) {
        if (StringUtils.isEmpty((CharSequence)applicationId)) {
            return;
        }
        Validate.isTrue((boolean)APPLICATIONID_PATTERN.matcher(applicationId).matches());
    }

    public String getId() {
        return this.id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getName() {
        return this.name;
    }

    public IdentifierType getType() {
        return this.type;
    }

    public boolean isNaturalPerson() {
        return this.getType() == IdentifierType.SSIN;
    }

    public Map<String, Object> toOIDMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("C", "BE");
        result.put("O", "Federal Government");
        LinkedHashSet<String> ou = new LinkedHashSet<String>();
        ou.add("eHealth-platform Belgium");
        ou.add(this.name);
        String ou3 = this.type.getType(48) + "\\=" + this.id;
        ou.add(ou3);
        if (StringUtils.isNotEmpty((CharSequence)this.applicationId)) {
            ou.add(this.applicationId);
            result.put("CN", ou3 + "\\, " + this.applicationId);
        } else {
            result.put("CN", ou3);
        }
        result.put("OU", ou);
        return result;
    }

    public String asNormalizedEhealthDN() {
        Map<String, Object> oidMap = this.toOIDMap();
        StringBuffer sb = new StringBuffer();
        sb.append("CN=").append(oidMap.get("CN")).append(",");
        Set ouSet = (Set)oidMap.get("OU");
        for (String ou : ouSet) {
            sb.append("OU=").append(ou).append(",");
        }
        sb.append("O=").append(oidMap.get("O")).append(",");
        sb.append("C=").append(oidMap.get("C"));
        return sb.toString();
    }

    public String asNormalisedBaseFileName() {
        if (StringUtils.isBlank((CharSequence)basename)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type.getType(48)).append("=").append(this.id);
            if (!StringUtils.isBlank((CharSequence)this.applicationId)) {
                sb.append(",");
                sb.append(this.applicationId);
            }
            sb.append(" ");
            sb.append(DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss").print((ReadableInstant)new DateTime())).append(".p12");
            basename = sb.toString();
        }
        return basename;
    }

    private static Identity getIdentity() throws TechnicalConnectorException {
        if (identity == null) {
            identity = BeIDInfo.getInstance().getIdentity();
        }
        return identity;
    }

    private static String normalize(String str) {
        if (str == null) {
            return null;
        }
        return Normalizer.normalize(str.toUpperCase(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    private static <T> T notNull(T obj) {
        Validate.notNull(obj);
        return obj;
    }

    private String getValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            return DistinguishedName.convertToString((byte[])value);
        }
        LOG.error("Unsupported value [" + value.getClass() + "]");
        return "";
    }

    private static String convertToString(byte[] value) {
        try {
            ASN1Primitive content = ASN1Primitive.fromByteArray((byte[])value);
            if (content instanceof DERPrintableString) {
                return ((DERPrintableString)content).getString();
            }
            LOG.error("Unsupported ASN1Object :" + content.getClass());
        }
        catch (Exception e) {
            LOG.error("Error while converting to String", (Throwable)e);
        }
        return null;
    }
}

