/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.builders;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.technicalconnector.ra.domain.ContactData;
import be.fgov.ehealth.technicalconnector.ra.domain.Contract;
import be.fgov.ehealth.technicalconnector.ra.domain.DistinguishedName;
import be.fgov.ehealth.technicalconnector.ra.domain.NewCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.domain.Organization;
import be.fgov.ehealth.technicalconnector.ra.domain.RenewCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.domain.RevokeCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.enumaration.Language;
import be.fgov.ehealth.technicalconnector.ra.enumaration.RevocationReason;
import be.fgov.ehealth.technicalconnector.ra.enumaration.UsageType;
import be.fgov.ehealth.technicalconnector.ra.utils.CertificateUtils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class ContractBuilder {
    private ContractBuilder() {
        throw new UnsupportedOperationException();
    }

    private static abstract class BasicSteps<T extends Contract>
    implements RevokeReasonStep<T>,
    RevokeReasonDetailStep<T>,
    OrganizationChoiceStep1<T>,
    OrganizationChoiceStep2<T>,
    OrganizationChoiceStep3<T>,
    ContactDataStep1<T>,
    ContactDataStep2<T>,
    ContactDataStep3<T>,
    BuildStep<T>,
    LanguageChoiceStep<T>,
    Pkcs10GenerationStep<T> {
        private Language lang;
        private int type;
        protected X509Certificate subject;
        private String personalEmail;
        private String personalPhone;
        private String generalEmail;
        private String generalPhone;
        private UsageType[] usageTypes;
        private RevocationReason revokeReason;
        private String revokeDetail;
        private String applicationId;
        private String organizationName;
        private IdentifierType organizationIdentifier;
        private String organizationId;
        private KeyPair keypair;

        public BasicSteps(int type) {
            this.type = type;
        }

        protected void setSubject(X509Certificate cert) {
            Validate.notNull((Object)cert);
            this.subject = cert;
        }

        @Override
        public ContactDataStep<T> withApplicationId(String applicationId) {
            Validate.notEmpty((String)applicationId);
            this.applicationId = applicationId;
            return this;
        }

        @Override
        public OrganizationChoiceStep3<T> withName(String name) {
            Validate.notEmpty((String)name);
            this.organizationName = name;
            return this;
        }

        @Override
        public OrganizationChoiceStep2<T> withId(String id, IdentifierType type) {
            Validate.notEmpty((String)id);
            Validate.notNull((Object)type);
            this.organizationId = id;
            this.organizationIdentifier = type;
            return this;
        }

        @Override
        public ContactDataStep1<T> withPrivatePhone(String phone) {
            this.personalPhone = phone;
            return this;
        }

        @Override
        public Pkcs10GenerationStep<T> withUsageType(UsageType ... types) {
            this.usageTypes = types;
            return this;
        }

        @Override
        public LanguageChoiceStep<T> generatePKCS10(KeyPair keypair) {
            Validate.notNull((Object)keypair);
            this.keypair = keypair;
            return this;
        }

        @Override
        public UsageTypeStep<T> withGeneralEmail(String mail) {
            this.generalEmail = mail;
            return this;
        }

        @Override
        public ContactDataStep3<T> withGeneralPhone(String phone) {
            this.generalPhone = phone;
            return this;
        }

        @Override
        public ContactDataStep2<T> withPrivateEmail(String mail) {
            this.personalEmail = mail;
            return this;
        }

        @Override
        public RevokeReasonDetailStep<T> withReason(RevocationReason reason) {
            Validate.notNull((Object)((Object)reason));
            this.revokeReason = reason;
            return this;
        }

        @Override
        public LanguageChoiceStep<T> withExplanation(String msg) {
            Validate.notEmpty((String)msg);
            this.revokeDetail = msg;
            return this;
        }

        @Override
        public BuildStep<T> useLanguage(Language lang) {
            Validate.notNull((Object)((Object)lang));
            this.lang = lang;
            return this;
        }

        @Override
        public T build() throws TechnicalConnectorException {
            switch (this.type) {
                case 0: {
                    DistinguishedName name = null;
                    if (StringUtils.isNotEmpty((String)this.organizationId)) {
                        Organization organization = new Organization(this.organizationId, this.organizationIdentifier, this.organizationName);
                        name = new DistinguishedName(organization, this.applicationId);
                    } else {
                        name = new DistinguishedName();
                    }
                    NewCertificateContract newContract = new NewCertificateContract(name, this.generateContactData(), this.usageTypes);
                    if (this.keypair != null) {
                        newContract.setPkcs10DerEncoded(CertificateUtils.createCSR(name, this.keypair));
                    }
                    return (T)newContract;
                }
                case 1: {
                    RenewCertificateContract renewContract = new RenewCertificateContract(this.subject, this.generateContactData(), this.usageTypes);
                    if (this.keypair != null) {
                        renewContract.setPkcs10DerEncoded(CertificateUtils.createCSR(renewContract.getDistinguishedName(), this.keypair));
                    }
                    return (T)renewContract;
                }
                case 2: {
                    if (StringUtils.isNotEmpty((String)this.revokeDetail)) {
                        return (T)new RevokeCertificateContract(this.subject, this.revokeReason, this.revokeDetail, this.lang);
                    }
                    return (T)new RevokeCertificateContract(this.subject, this.revokeReason, this.lang);
                }
            }
            throw new IllegalArgumentException("Unsupported type");
        }

        private ContactData generateContactData() {
            ContactData contact = StringUtils.isEmpty((String)this.generalEmail) ? new ContactData(this.personalPhone, this.personalEmail, this.lang) : new ContactData(this.generalPhone, this.personalPhone, this.generalEmail, this.personalEmail, this.lang);
            return contact;
        }
    }

    private static class CreateSteps
    extends BasicSteps<NewCertificateContract>
    implements CreateStep<NewCertificateContract> {
        public CreateSteps() {
            super(0);
        }

        @Override
        public ContactDataStep<NewCertificateContract> withEid() {
            return this;
        }

        @Override
        public OrganizationChoiceStep1<NewCertificateContract> forOrganization() {
            return this;
        }

        @Override
        public OrganizationChoiceStep3<NewCertificateContract> forOrganization(Organization organization) {
            this.withId(organization.getId(), organization.getType());
            this.withName(organization.getName());
            return this;
        }
    }

    private static class RevokeSteps
    extends BasicSteps<RevokeCertificateContract>
    implements RevokeStep<RevokeCertificateContract> {
        public RevokeSteps() {
            super(2);
        }

        @Override
        public RevokeReasonStep<RevokeCertificateContract> withCert(X509Certificate cert) {
            this.setSubject(cert);
            return this;
        }
    }

    private static class RenewSteps
    extends BasicSteps<RenewCertificateContract>
    implements RenewStep<RenewCertificateContract> {
        public RenewSteps() {
            super(1);
        }

        @Override
        public ContactDataStep<RenewCertificateContract> withCert(X509Certificate cert) {
            this.setSubject(cert);
            return this;
        }
    }

    public static interface BuildStep<T extends Contract> {
        public T build() throws TechnicalConnectorException;
    }

    public static interface LanguageChoiceStep<T extends Contract> {
        public BuildStep<T> useLanguage(Language var1);
    }

    public static interface RevokeReasonDetailStep<T extends Contract>
    extends LanguageChoiceStep<T> {
        public LanguageChoiceStep<T> withExplanation(String var1);
    }

    public static interface RevokeReasonStep<T extends Contract> {
        public RevokeReasonDetailStep<T> withReason(RevocationReason var1);
    }

    public static interface Pkcs10GenerationStep<T extends Contract>
    extends LanguageChoiceStep<T> {
        public LanguageChoiceStep<T> generatePKCS10(KeyPair var1);
    }

    public static interface UsageTypeStep<T extends Contract>
    extends Pkcs10GenerationStep<T> {
        public Pkcs10GenerationStep<T> withUsageType(UsageType ... var1);
    }

    public static interface ContactDataStep3<T extends Contract> {
        public UsageTypeStep<T> withGeneralEmail(String var1);
    }

    public static interface ContactDataStep2<T extends Contract>
    extends UsageTypeStep<T> {
        public ContactDataStep3<T> withGeneralPhone(String var1);
    }

    public static interface ContactDataStep1<T extends Contract> {
        public ContactDataStep2<T> withPrivateEmail(String var1);
    }

    public static interface ContactDataStep<T extends Contract> {
        public ContactDataStep1<T> withPrivatePhone(String var1);
    }

    public static interface OrganizationChoiceStep3<T extends Contract>
    extends ContactDataStep<T> {
        public ContactDataStep<T> withApplicationId(String var1);
    }

    public static interface OrganizationChoiceStep2<T extends Contract> {
        public OrganizationChoiceStep3<T> withName(String var1);
    }

    public static interface OrganizationChoiceStep1<T extends Contract> {
        public OrganizationChoiceStep2<T> withId(String var1, IdentifierType var2);
    }

    public static interface RevokeStep<T extends Contract> {
        public RevokeReasonStep<T> withCert(X509Certificate var1);
    }

    public static interface RenewStep<T extends Contract> {
        public ContactDataStep<T> withCert(X509Certificate var1);
    }

    public static interface CreateStep<T extends Contract> {
        public ContactDataStep<T> withEid();

        public OrganizationChoiceStep1<T> forOrganization();

        public OrganizationChoiceStep3<T> forOrganization(Organization var1);
    }

    static class ContractSteps
    implements ContractBuilderStep {
        ContractSteps() {
        }

        @Override
        public CreateStep<NewCertificateContract> create() {
            return new CreateSteps();
        }

        @Override
        public RenewStep<RenewCertificateContract> renew() {
            return new RenewSteps();
        }

        @Override
        public RevokeStep<RevokeCertificateContract> revoke() {
            return new RevokeSteps();
        }
    }

    public static interface ContractBuilderStep {
        public CreateStep<NewCertificateContract> create();

        public RenewStep<RenewCertificateContract> renew();

        public RevokeStep<RevokeCertificateContract> revoke();
    }
}

