/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.distributedkeys.jca;

import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedKeyLoadStoreParam;
import be.fgov.ehealth.technicalconnector.distributedkeys.jca.DistributedPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedKeyStore
extends KeyStoreSpi {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedKeyStore.class);
    private DistributedKeyLoadStoreParam keyStoreParameter;
    private Map<String, Certificate[]> cache = new HashMap<String, Certificate[]>();

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param instanceof DistributedKeyLoadStoreParam) {
            this.keyStoreParameter = (DistributedKeyLoadStoreParam)param;
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return new DistributedPrivateKey(this.keyStoreParameter.getProxy(), alias);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.cache.containsKey(alias)) {
            LOG.debug("Adding [" + alias + "] to cache");
            this.cache.put(alias, this.keyStoreParameter.getProxy().getCertificateChain(alias).toArray(new Certificate[0]));
        }
        return this.cache.get(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            LOG.debug("Trying to obtain certificate with Alias [" + alias + "]");
            return this.engineGetCertificateChain(alias)[0];
        }
        catch (Exception e) {
            LOG.error("Unable to obtain certificate with alias [" + alias + "]", (Throwable)e);
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        LOG.debug("Unsupported operation enginSetKeyEntry");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        LOG.debug("Unsupported operation engineSetKeyEntry");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        LOG.debug("Unsupported operation engineSetCertificateEntry");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LOG.debug("Unsupported operation engineDeleteEntry");
    }

    @Override
    public Enumeration<String> engineAliases() {
        Set<String> aliases = this.keyStoreParameter.getProxy().getAliases();
        return Collections.enumeration(aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Set<String> aliases = this.keyStoreParameter.getProxy().getAliases();
        return aliases.contains(alias);
    }

    @Override
    public int engineSize() {
        Set<String> aliases = this.keyStoreParameter.getProxy().getAliases();
        return aliases.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Set<String> aliases = this.keyStoreParameter.getProxy().getAliases();
        return aliases.contains(alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("Unsupported operation engineStore");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("Unsupported operation engineLoad");
    }
}

