/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.enumeration.CryptoType;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.SessionManager;
import be.fgov.ehealth.commons.core.v1.IdentifierType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtil.class);
    private static final int NIHII8_LENGTH = 8;
    private static final String ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:assertion";
    private static final String SAML_ATTRIBUTE_NAMESPACE = "AttributeNamespace";
    private static final String SAML_ATTRIBUTE_NAME = "AttributeName";
    private static final String ATTR_NAMESPACE = "urn:be:fgov:certified-namespace:ehealth";
    private static final String SUFFIX_NIHII11 = ".*nihii11$";
    private static final String USER_LASTNAME = "user.lastname";
    private static final String USER_FIRSTNAME = "user.firstname";
    private static final String USER_NIHII = "user.nihii";
    private static final String USER_INSS = "user.inss";
    private static final String SAML_ATTRIBUTE = "Attribute";

    private static Configuration getConfig() {
        return ConfigFactory.getConfigValidatorFor(USER_INSS, USER_NIHII, USER_FIRSTNAME, USER_LASTNAME);
    }

    private SessionUtil() {
        throw new UnsupportedOperationException();
    }

    public static Crypto getCrypto(CryptoType type, Crypto defaultCrypto) throws TechnicalConnectorException {
        if (defaultCrypto == null) {
            switch (type) {
                case HOLDER_OF_KEY: {
                    return SessionUtil.getHolderOfKeyCrypto();
                }
                case ENCRYPTION: {
                    return SessionUtil.getEncryptionCrypto();
                }
            }
            throw new IllegalArgumentException("Unsupported CryptoType " + (Object)((Object)type));
        }
        return defaultCrypto;
    }

    public static Credential getCredentail(CryptoType type, Credential defaultCredential) throws TechnicalConnectorException {
        if (defaultCredential == null) {
            switch (type) {
                case HOLDER_OF_KEY: {
                    return SessionUtil.getHolderOfKeyCredential();
                }
                case ENCRYPTION: {
                    return SessionUtil.getEncryptionCredential();
                }
            }
            throw new IllegalArgumentException("Unsupported CryptoType " + (Object)((Object)type));
        }
        return defaultCredential;
    }

    public static Crypto getEncryptionCrypto() throws TechnicalConnectorException {
        SessionItem session = SessionUtil.checkAndRetrieveSession();
        if (session.getEncryptionCrypto() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, "there was no encryption crypto found in the session");
        }
        return session.getEncryptionCrypto();
    }

    public static Crypto getHolderOfKeyCrypto() throws TechnicalConnectorException {
        SessionItem session = SessionUtil.checkAndRetrieveSession();
        if (session.getHolderOfKeyCrypto() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, "there was no holder of key crypto found in the session");
        }
        return session.getHolderOfKeyCrypto();
    }

    public static Credential getHolderOfKeyCredential() throws TechnicalConnectorException {
        SessionItem session = SessionUtil.checkAndRetrieveSession();
        if (session.getHolderOfKeyCredential() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, "there was no holder of key credential found in the session");
        }
        return session.getHolderOfKeyCredential();
    }

    public static Credential getEncryptionCredential() throws TechnicalConnectorException {
        SessionItem session = SessionUtil.checkAndRetrieveSession();
        if (session.getEncryptionCredential() == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, "there was no encryption credential found in the session");
        }
        return session.getEncryptionCredential();
    }

    public static SessionItem checkAndRetrieveSession() throws TechnicalConnectorException {
        SessionItem session = Session.getInstance().getSession();
        if (!Session.getInstance().hasValidSession()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
        }
        return session;
    }

    public static String getNihii11() throws TechnicalConnectorException {
        String nihii = null;
        if (!SessionUtil.getConfig().hasProperty(USER_NIHII)) {
            LOG.debug("Could not find propertyuser.nihii in the configuration.");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_PROPERTY, USER_NIHII);
        }
        nihii = SessionUtil.getConfig().getProperty(USER_NIHII);
        SessionUtil.validateToken(nihii, SUFFIX_NIHII11);
        return nihii;
    }

    public static String getNihii() throws TechnicalConnectorException {
        String nihii = null;
        if (!SessionUtil.getConfig().hasProperty(USER_NIHII)) {
            LOG.debug("Could not find property user.nihii in the configuration.");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_PROPERTY, USER_NIHII);
        }
        nihii = SessionUtil.getConfig().getProperty(USER_NIHII);
        SessionUtil.validateToken(nihii, SUFFIX_NIHII11);
        return nihii.substring(0, 8);
    }

    public static String getNiss() throws TechnicalConnectorException {
        String niss = null;
        if (!SessionUtil.getConfig().hasProperty(USER_INSS)) {
            LOG.debug("Could not find property user.inss  in the configuration.");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_PROPERTY, USER_INSS);
        }
        niss = SessionUtil.getConfig().getProperty(USER_INSS);
        return niss;
    }

    public static IdentifierType createIdentifierType(String identifier, String type) {
        IdentifierType ident = new IdentifierType();
        ident.setId(identifier);
        ident.setType(type);
        return ident;
    }

    public static String getFullName() {
        StringBuilder sb = new StringBuilder();
        sb.append(SessionUtil.getConfig().getProperty(USER_FIRSTNAME));
        sb.append(" ");
        sb.append(SessionUtil.getConfig().getProperty(USER_LASTNAME));
        return sb.toString();
    }

    public static String getFirstname() {
        return SessionUtil.getConfig().getProperty(USER_FIRSTNAME);
    }

    public static String getLastname() {
        return SessionUtil.getConfig().getProperty(USER_LASTNAME);
    }

    private static void validateToken(String configValue, String attributeNameRegex) throws TechnicalConnectorException {
        Element token;
        List<String> tokenValueList;
        SessionManager sessionMgr = Session.getInstance();
        if (sessionMgr.hasValidSession() && !SessionUtil.containsCaseInsensitive(configValue, tokenValueList = SessionUtil.getAttributeValue(token = sessionMgr.getSession().getSAMLToken().getAssertion(), attributeNameRegex))) {
            LOG.warn("Inconsisting configuration, expecting value [" + configValue + "] but gets [" + ArrayUtils.toString((Object)tokenValueList.toArray(new String[0])) + "]");
        }
    }

    public static boolean containsCaseInsensitive(String strToCompare, List<String> list) {
        for (String str : list) {
            if (!str.equalsIgnoreCase(strToCompare)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<String>> getMatchingAttributes(String namespacePattern, String attributeNamePattern) throws TechnicalConnectorException {
        SessionManager sessionMgr = Session.getInstance();
        if (sessionMgr.hasValidSession()) {
            Element token = sessionMgr.getSession().getSAMLToken().getAssertion();
            NodeList attributes = SessionUtil.extractAttributes(token);
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node node = attributes.item(i);
                    NamedNodeMap attr = node.getAttributes();
                    String attributeName = attr.getNamedItem(SAML_ATTRIBUTE_NAME).getTextContent();
                    String attributeNamespace = attr.getNamedItem(SAML_ATTRIBUTE_NAMESPACE).getTextContent();
                    if (!attributeName.matches(attributeNamePattern) || !attributeNamespace.matches(namespacePattern)) continue;
                    if (node.hasChildNodes()) {
                        NodeList attributeValueNodeList = node.getChildNodes();
                        ArrayList<String> values = new ArrayList<String>();
                        for (int index = 0; index < attributeValueNodeList.getLength(); ++index) {
                            values.add(attributeValueNodeList.item(index).getTextContent().trim());
                        }
                        result.put(attributeName, values);
                        continue;
                    }
                    result.put(attributeName, Arrays.asList(node.getTextContent().trim()));
                }
            }
            return result;
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_VALID_SESSION, new Object[0]);
    }

    @Deprecated
    public static Map<String, List<String>> getMatchingAttributes(String attributeNamePattern) throws TechnicalConnectorException {
        return SessionUtil.getMatchingAttributes(".*", attributeNamePattern);
    }

    private static List<String> getAttributeValue(Element token, String attributeNameSuffix) throws TechnicalConnectorException {
        NodeList attributes = SessionUtil.extractAttributes(token);
        ArrayList<String> result = new ArrayList<String>();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                String attributeName = node.getAttributes().getNamedItem(SAML_ATTRIBUTE_NAME).getTextContent();
                String attributeNamespace = node.getAttributes().getNamedItem(SAML_ATTRIBUTE_NAMESPACE).getTextContent();
                if (!attributeName.matches(attributeNameSuffix) || !attributeNamespace.equals(ATTR_NAMESPACE)) continue;
                if (node.hasChildNodes()) {
                    NodeList attributeValueNodeList = node.getChildNodes();
                    for (int index = 0; index < attributeValueNodeList.getLength(); ++index) {
                        result.add(attributeValueNodeList.item(index).getTextContent().trim());
                    }
                    continue;
                }
                result.add(node.getTextContent().trim());
            }
        }
        if (result.isEmpty()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_TOKEN, "Token doesn't contain an attribute with " + attributeNameSuffix + " in namespace " + ATTR_NAMESPACE);
        }
        return result;
    }

    private static NodeList extractAttributes(Element element) {
        NodeList attributes = element.getElementsByTagName(SAML_ATTRIBUTE);
        if (attributes.getLength() == 0 && (attributes = element.getElementsByTagNameNS(ASSERTION_NAMESPACE, SAML_ATTRIBUTE)).getLength() == 0) {
            return null;
        }
        return attributes;
    }
}

