/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.InstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttribute;
import be.ehealth.technicalconnector.service.sts.domain.SAMLAttributeDesignator;
import be.ehealth.technicalconnector.service.sts.domain.SAMLNameIdentifier;
import be.ehealth.technicalconnector.service.sts.impl.AbstractSTSService;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.utils.SAMLConverter;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.ehealth.technicalconnector.service.ws.ServiceFactory;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.feature.SHA1Feature;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STSServiceImpl
extends AbstractSTSService {
    private static final String ATTRIBUTE_NAME = "AttributeName";
    private static final Logger LOG = LoggerFactory.getLogger(STSServiceImpl.class);
    private static final String ATTRIBUTE_QUERY = "AttributeQuery";
    private static final String AUTHENTICATION_STATEMENT = "AuthenticationStatement";
    private static final String ATTRIBUTE_STATEMENT = "AttributeStatement";
    private static final String CONFIRMATION_METHOD = "ConfirmationMethod";
    private static final String ATTRIBUTE_VALUE = "AttributeValue";
    private static final String ATTRIBUTE = "Attribute";
    private static final String ATTRIBUTE_NAMESPACE = "AttributeNamespace";
    private static final String XMLNS_SAML = "urn:oasis:names:tc:SAML:1.0:assertion";
    public static final String HOK_KEYINFO_TYPE = "be.ehealth.technicalconnector.service.sts.keyinfo";
    public static final String ALWAYS_SIGN_INNER_REQUEST = "be.ehealth.technicalconnector.service.sts.always.sign.inner.request";
    private static final String JSR105PROVIDER_CLASSNAME_DEFAULT = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final XMLSignatureFactory xmlSignatureFactory;

    @Override
    public Element getToken(Credential headerCredentials, Credential bodyCredentials, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, String authenticationMethod, String nameQualifier, String value, String subjectConfirmationMethod, Duration validity) throws TechnicalConnectorException {
        try {
            SAMLNameIdentifier nameIdentifier = this.generateNameIdentifier(headerCredentials, nameQualifier, value);
            String requestTemplate = "";
            boolean sign = false;
            if (subjectConfirmationMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
                sign = true;
                String keyinfoType = ConfigFactory.getConfigValidator().getProperty(HOK_KEYINFO_TYPE, "x509");
                requestTemplate = "publickey".equalsIgnoreCase(keyinfoType) ? ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/legacy/issue.samlv11.hok.publickey.template.xml")) : ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/legacy/issue.samlv11.hok.template.xml"));
            } else if (subjectConfirmationMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches")) {
                requestTemplate = StringUtils.isEmpty((CharSequence)authenticationMethod) ? ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/legacy/issue.samlv11.sv.template.xml")) : ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream("/legacy/issue.samlv11.sv.authmethod.template.xml"));
            } else {
                throw new UnsupportedOperationException("SubjectConfirmationMethod [" + subjectConfirmationMethod + "] not supported.");
            }
            Document samlRequest = this.generateToken(requestTemplate, sign, headerCredentials, bodyCredentials, nameIdentifier, authenticationMethod, attributes, designators, validity);
            GenericRequest request = ServiceFactory.getSTSService(headerCredentials.getCertificate(), headerCredentials.getPrivateKey());
            request.setSoapAction("urn:be:fgov:ehealth:sts:protocol:v1:RequestSecureToken");
            request.setPayload(samlRequest, new SHA1Feature(){

                @Override
                protected String getSignatureECMethodAlgorithm() {
                    return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                }

                @Override
                protected String getDigestECMethodAlgorithm() {
                    return "http://www.w3.org/2001/04/xmlenc#sha256";
                }
            });
            Source response = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(request).asSource();
            Element stsResponse = SAMLConverter.convert(response);
            String status = SAMLHelper.getStatusCode(stsResponse);
            if (!status.contains("Success")) {
                LOG.warn("The status of the SAMLResponse is " + status + " [" + SAMLHelper.getStatusMessage(stsResponse));
                TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.INVALID_TOKEN;
                throw new TechnicalConnectorException(errorValue, "Inbound Security problem: " + SAMLHelper.getStatusMessage(stsResponse));
            }
            if (stsResponse.getElementsByTagName("Assertion").getLength() < 0) {
                String message = "SAMLResponse has a flag succesfull but contains no assertions.";
                LOG.warn(message);
                LOG.warn("SAMLResponse was: " + SAMLConverter.toXMLString(stsResponse));
                LOG.warn("The status of the SAMLResponse is " + status + " [" + SAMLHelper.getStatusMessage(stsResponse));
                TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.INVALID_TOKEN;
                throw new TechnicalConnectorException(errorValue, message);
            }
            return SAMLHelper.getAssertion(stsResponse);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public Element getToken(Credential headerCredentials, Credential bodyCredentials, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, String subjectConfirmationMethod, Duration validity) throws TechnicalConnectorException {
        return this.getToken(headerCredentials, bodyCredentials, attributes, designators, null, null, null, subjectConfirmationMethod, validity);
    }

    @Override
    public Element renewToken(Credential headerCredentials, Credential bodyCredentials, Element samlToken, Duration validity) throws TechnicalConnectorException {
        ArrayList<SAMLAttributeDesignator> designators = new ArrayList<SAMLAttributeDesignator>();
        ArrayList<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>();
        NodeList authenticationStatementList = samlToken.getElementsByTagNameNS(XMLNS_SAML, AUTHENTICATION_STATEMENT);
        HashSet<String> idenAttr = new HashSet<String>();
        for (int i = 0; i < authenticationStatementList.getLength(); ++i) {
            NodeList attrList = ((Element)authenticationStatementList.item(i)).getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE);
            for (int j = 0; j < attrList.getLength(); ++j) {
                Element attr = (Element)attrList.item(j);
                String namespace = attr.getAttribute(ATTRIBUTE_NAMESPACE);
                String name = attr.getAttribute(ATTRIBUTE_NAME);
                String[] values = this.extractTextContent(attr.getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE_VALUE));
                if ("urn:be:fgov:certified-namespace:ehealth".equals(namespace)) continue;
                attributes.add(new SAMLAttribute(name, namespace, values));
                idenAttr.add(name);
            }
        }
        NodeList attributesList = samlToken.getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE_STATEMENT);
        for (int i = 0; i < attributesList.getLength(); ++i) {
            NodeList attrList = ((Element)attributesList.item(i)).getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE);
            for (int j = 0; j < attrList.getLength(); ++j) {
                Element attr = (Element)attrList.item(j);
                String namespace = attr.getAttribute(ATTRIBUTE_NAMESPACE);
                String name = attr.getAttribute(ATTRIBUTE_NAME);
                designators.add(new SAMLAttributeDesignator(name, namespace));
                if (idenAttr.contains(name)) continue;
                String[] values = this.extractTextContent(attr.getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE_VALUE));
                if ("urn:be:fgov:certified-namespace:ehealth".equals(namespace)) continue;
                attributes.add(new SAMLAttribute(name, namespace, values));
            }
        }
        String subjectConfirmationMethod = samlToken.getElementsByTagNameNS(XMLNS_SAML, CONFIRMATION_METHOD).item(0).getTextContent();
        String authenticationMethod = null;
        for (int i = 0; i < authenticationStatementList.getLength(); ++i) {
            Element authenticationStatement = (Element)authenticationStatementList.item(i);
            authenticationMethod = authenticationStatement.getAttribute("AuthenticationMethod");
        }
        String nameQualifier = null;
        String value = null;
        NodeList nameIdentifierList = samlToken.getElementsByTagNameNS(XMLNS_SAML, "NameIdentifier");
        for (int i = 0; i < attributesList.getLength(); ++i) {
            Element nameIdentifier = (Element)nameIdentifierList.item(i);
            if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(nameIdentifier.getAttribute("Format"))) continue;
            nameQualifier = StringEscapeUtils.escapeXml((String)nameIdentifier.getAttribute("NameQualifier"));
            value = StringEscapeUtils.escapeXml((String)nameIdentifier.getTextContent());
            break;
        }
        return this.getToken(headerCredentials, bodyCredentials, attributes, designators, authenticationMethod, nameQualifier, value, subjectConfirmationMethod, validity);
    }

    private String[] extractTextContent(NodeList nodelist) {
        Object[] result = ArrayUtils.EMPTY_STRING_ARRAY;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Element el = (Element)nodelist.item(i);
            result = (String[])ArrayUtils.add((Object[])result, (Object)el.getTextContent());
        }
        return result;
    }

    private Document generateToken(String requestTemplate, boolean sign, Credential headerCred, Credential hokCred, SAMLNameIdentifier nameIdentifier, String authmethod, List<SAMLAttribute> attributes, List<SAMLAttributeDesignator> designators, Duration validity) throws TechnicalConnectorException {
        try {
            String request = ConnectorXmlUtils.flatten(requestTemplate);
            request = this.processDefaultFields(request, validity, nameIdentifier);
            request = this.processHolderOfKeyCredentials(hokCred, request);
            request = StringUtils.replace((String)request, (String)"${authenticationMethod}", (String)authmethod);
            Element payload = ConnectorXmlUtils.toElement(request.getBytes(Charsets.UTF_8));
            Document doc = payload.getOwnerDocument();
            this.addDesignators(designators, doc);
            this.processAttributes(attributes, doc);
            boolean alwaysSign = Boolean.parseBoolean(ConfigFactory.getConfigValidator().getProperty(ALWAYS_SIGN_INNER_REQUEST));
            if (sign && (!headerCred.getCertificate().equals(hokCred.getCertificate()) || alwaysSign)) {
                try {
                    String keyinfoType = ConfigFactory.getConfigValidator().getProperty(HOK_KEYINFO_TYPE, "x509");
                    if ("publickey".equalsIgnoreCase(keyinfoType)) {
                        this.signRequest(doc.getDocumentElement(), hokCred.getPrivateKey(), hokCred.getPublicKey());
                    } else {
                        this.signRequest(doc.getDocumentElement(), hokCred.getPrivateKey(), hokCred.getCertificate());
                    }
                }
                catch (Exception e) {
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_SIGNATURE, "XML signature error: " + e.getMessage(), e);
                }
            }
            return doc;
        }
        catch (CertificateEncodingException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, (Throwable)e, e.getMessage());
        }
    }

    private void processAttributes(List<SAMLAttribute> attributes, Document doc) {
        Element attributeStatement = (Element)doc.getElementsByTagNameNS(XMLNS_SAML, ATTRIBUTE_STATEMENT).item(0);
        for (SAMLAttribute attr : attributes) {
            Element attrEl = doc.createElementNS(XMLNS_SAML, "saml:Attribute");
            attrEl.setAttribute(ATTRIBUTE_NAME, attr.getName());
            attrEl.setAttribute(ATTRIBUTE_NAMESPACE, attr.getNamespace());
            this.processAttributeValues(attrEl, attr.getValues());
            attributeStatement.appendChild(attrEl);
        }
    }

    private void addDesignators(List<SAMLAttributeDesignator> designators, Document doc) {
        Element attributeQuery = (Element)doc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", ATTRIBUTE_QUERY).item(0);
        for (SAMLAttributeDesignator attr : designators) {
            Element attrEl = doc.createElementNS(XMLNS_SAML, "saml:AttributeDesignator");
            attrEl.setAttribute(ATTRIBUTE_NAME, attr.getName());
            attrEl.setAttribute(ATTRIBUTE_NAMESPACE, attr.getNamespace());
            attributeQuery.appendChild(attrEl);
        }
    }

    private String processHolderOfKeyCredentials(Credential hokCred, String request) throws TechnicalConnectorException, CertificateEncodingException {
        if (hokCred != null && hokCred.getCertificate() != null) {
            request = StringUtils.replace((String)request, (String)"${holder.of.key}", (String)new String(Base64.encode((byte[])hokCred.getCertificate().getEncoded())));
            PublicKey publicKey = hokCred.getCertificate().getPublicKey();
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                request = StringUtils.replace((String)request, (String)"${publickey.rsa.modulus}", (String)new String(Base64.encode((byte[])STSServiceImpl.convertTo(rsaPublicKey.getModulus()))));
                request = StringUtils.replace((String)request, (String)"${publickey.rsa.exponent}", (String)new String(Base64.encode((byte[])STSServiceImpl.convertTo(rsaPublicKey.getPublicExponent()))));
                request = StringUtils.replace((String)request, (String)"<ds:DSAKeyValue><ds:G>${publickey.dsa.g}<ds:G><ds:P>${publickey.dsa.p}</ds:P><ds:Q>${publickey.dsa.q}</ds:Q></ds:DSAKeyValue>", (String)"");
            } else if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
                request = StringUtils.replace((String)request, (String)"${publickey.dsa.g}", (String)new String(Base64.encode((byte[])STSServiceImpl.convertTo(dsaPublicKey.getParams().getG()))));
                request = StringUtils.replace((String)request, (String)"${publickey.dsa.p}", (String)new String(Base64.encode((byte[])STSServiceImpl.convertTo(dsaPublicKey.getParams().getP()))));
                request = StringUtils.replace((String)request, (String)"${publickey.dsa.q}", (String)new String(Base64.encode((byte[])STSServiceImpl.convertTo(dsaPublicKey.getParams().getQ()))));
                request = StringUtils.replace((String)request, (String)"<ds:RSAKeyValue><ds:Modulus>${publickey.rsa.modulus}</ds:Modulus><ds:Exponent>${publickey.rsa.exponent}</ds:Exponent></ds:RSAKeyValue>", (String)"");
            } else {
                LOG.info("Unsupported public key: [" + publicKey.getClass().getName() + "+]");
            }
        }
        return request;
    }

    private void processAttributeValues(Element attrEl, String[] attributeValues) {
        for (String attributeValue : attributeValues) {
            Element attrVal = attrEl.getOwnerDocument().createElementNS(XMLNS_SAML, "saml:AttributeValue");
            attrVal.setTextContent(attributeValue);
            attrEl.appendChild(attrVal);
        }
    }

    private void signRequest(Element requestElement, PrivateKey privateKey, Object keyInfoValue) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, KeyException {
        DOMSignContext domSignContext = new DOMSignContext(privateKey, (Node)requestElement, requestElement.getFirstChild());
        String requestId = requestElement.getAttribute("RequestID");
        requestElement.setIdAttribute("RequestID", true);
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        transforms.add(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null));
        Reference reference = xmlSignatureFactory.newReference("#" + requestId, xmlSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transforms, null, null);
        CanonicalizationMethod canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(reference));
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        KeyInfo keyInfo = null;
        if (keyInfoValue instanceof PublicKey) {
            keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue((PublicKey)keyInfoValue)));
        } else if (keyInfoValue instanceof X509Certificate) {
            keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newX509Data(Collections.singletonList(keyInfoValue))));
        } else {
            throw new IllegalArgumentException("Unsupported keyinfo type [" + keyInfoValue.getClass() + "]");
        }
        XMLSignature xmlSignature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        xmlSignature.sign(domSignContext);
    }

    private static byte[] convertTo(BigInteger bigInteger) {
        byte[] array = bigInteger.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return array;
    }

    static {
        try {
            String providerName = System.getProperty("jsr105Provider", JSR105PROVIDER_CLASSNAME_DEFAULT);
            LOG.info("Instantiating providate with class [" + providerName + "]");
            Provider provider = (Provider)Class.forName(providerName).newInstance();
            LOG.info("Using the following provider: " + provider + " " + provider.getInfo());
            xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", provider);
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        catch (java.lang.InstantiationException e) {
            throw new InstantiationException(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }
}

