/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.AbstractConfigurationImpl;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationWithSessionCache
extends AbstractConfigurationImpl
implements SessionServiceWithCache {
    private final Configuration configuration;
    private final Map<String, String> originalProperties = new HashMap<String, String>();

    public ConfigurationWithSessionCache(Configuration configuration) {
        this.configuration = configuration;
        Session.getInstance().registerSessionService(this);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.configuration.getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        this.originalProperties.put(key, this.configuration.getProperty(key));
        this.configuration.setProperty(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.configuration.hasProperty(key);
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        return this;
    }

    @Override
    public void invalidate() throws TechnicalConnectorException {
        this.configuration.invalidate();
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        this.configuration.reload();
    }

    @Override
    public boolean isReloading() {
        return this.configuration.isReloading();
    }

    @Override
    public void flushCache() {
        for (Map.Entry<String, String> entry : this.originalProperties.entrySet()) {
            this.configuration.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Deprecated
    public void setConfigLocation(String location) throws TechnicalConnectorException {
        ConfigFactory.setConfigLocation(location);
    }
}

