/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.InstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Configurator;

public final class ConfigurationModuleLoggingLog4j {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String CONNECTOR_LOGGER_CONFIG = "connector.logger.through.config";
    private static final String CONNECTOR_LOGGER_FILE_CONFIG_LOCATION = "connector.logger.fileconfig.location";
    public static final String CONNECTOR_LOGGER_FILE_CONFIG_TYPE = "connector.logger.fileconfig.type";
    private static final String CONNECTOR_LOGGER_FILE_FILEPATH = "connector.logger.file.filepath";
    private static final String CONNECTOR_LOGGER_FILE_ENABLED = "connector.logger.file.enabled";
    private static final String CONNECTOR_LOGGER_PATTERNLAYOUT = "connector.logger.patternlayout";
    private static final String CONNECTOR_LOGGER_LEVEL = "connector.logger.level";
    private static final String CONNECTOR_LOGGER_CONSOLE_ENABLED = "connector.logger.console.enabled";
    private Enumeration<?> oldAppenders;
    private static String defaultImplementation = "org.apache.log4j.xml.DOMConfigurator";
    private static String type = "xml";

    public void init(Properties config) {
        String executed = System.getProperty(this.getClass().getName(), FALSE);
        if (FALSE.equalsIgnoreCase(executed)) {
            InputStream is = null;
            this.oldAppenders = Logger.getRootLogger().getAllAppenders();
            boolean configLogger = Boolean.parseBoolean(config.getProperty(CONNECTOR_LOGGER_CONFIG, TRUE));
            if (configLogger) {
                boolean fileLogger;
                boolean consoleLogger = Boolean.parseBoolean(config.getProperty(CONNECTOR_LOGGER_CONSOLE_ENABLED, TRUE));
                String configLocation = this.determineLocation(consoleLogger, fileLogger = Boolean.parseBoolean(config.getProperty(CONNECTOR_LOGGER_FILE_ENABLED, FALSE)));
                if (configLocation == null) {
                    return;
                }
                byte[] configuration = this.getConfiguration(config, configLocation);
                is = new ByteArrayInputStream(configuration);
            } else {
                String configLocation = config.getProperty(CONNECTOR_LOGGER_FILE_CONFIG_LOCATION);
                if (StringUtils.isBlank((String)configLocation)) {
                    return;
                }
                try {
                    is = ConnectorIOUtils.getResourceAsStream(configLocation);
                }
                catch (TechnicalConnectorException e) {
                    throw new InstantiationException(e);
                }
            }
            try {
                Class<?> clazz = Class.forName(config.getProperty(CONNECTOR_LOGGER_FILE_CONFIG_TYPE, defaultImplementation));
                Configurator configurator = (Configurator)clazz.newInstance();
                configurator.doConfigure(is, LogManager.getLoggerRepository());
            }
            catch (Exception e) {
                throw new InstantiationException(e);
            }
            System.setProperty(this.getClass().getName(), TRUE);
        }
    }

    private byte[] getConfiguration(Properties config, String configLocation) {
        String configuration = "";
        try {
            configuration = IOUtils.toString((InputStream)ConnectorIOUtils.getResourceAsStream(configLocation), (String)Charset.UTF_8.getName());
        }
        catch (TechnicalConnectorException e) {
            throw new InstantiationException(e);
        }
        catch (IOException e) {
            throw new InstantiationException(e);
        }
        configuration = configuration.replaceAll("%%LEVEL%%", config.getProperty(CONNECTOR_LOGGER_LEVEL, "DEBUG"));
        configuration = configuration.replaceAll("%%PATTERN%%", config.getProperty(CONNECTOR_LOGGER_PATTERNLAYOUT, "%d{dd-MM-yyyy | HH:mm:ss} | %-5p | %c{1}:%L | %m%n"));
        if ("xml".equals(type)) {
            String value = config.getProperty(CONNECTOR_LOGGER_FILE_FILEPATH) + "";
            value = StringUtils.replace((String)value, (String)"./", (String)(System.getProperty("user.dir") + "/")).replace("\\", "/");
            configuration = configuration.replaceAll("%%FILE_NAME%%", value);
        } else {
            configuration = configuration.replaceAll("%%FILE_NAME%%", config.getProperty(CONNECTOR_LOGGER_FILE_FILEPATH));
        }
        try {
            return configuration.getBytes(Charset.UTF_8.getName());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstantiationException(e);
        }
    }

    private String determineLocation(boolean consoleLogger, boolean fileLogger) {
        String configLocation;
        if (consoleLogger && fileLogger) {
            configLocation = "/log4j/" + type + "/console.file";
        } else if (consoleLogger) {
            configLocation = "/log4j/" + type + "/console.only";
        } else if (fileLogger) {
            configLocation = "/log4j/" + type + "/file.only";
        } else {
            return null;
        }
        return configLocation;
    }

    public void unload() {
        Logger.getRootLogger().removeAllAppenders();
        while (this.oldAppenders.hasMoreElements()) {
            Appender appender = (Appender)this.oldAppenders.nextElement();
            Logger.getRootLogger().addAppender(appender);
        }
        System.setProperty(this.getClass().getName(), FALSE);
    }
}

