/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.config.impl.ConfigurationImpl;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationModuleLogging
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleLogging.class);
    private static final String PROP_LOG_ENABLED = "connector.logger.enabled";
    private static final boolean PROP_LOG_ENABLED_DEFAULT = true;
    private static final String PROP_LOG_FRAMEWORK_CLASS = "connector.logger.framework";
    private static final String PROP_LOG_FRAMEWORK_DEFAULT = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleLoggingLog4j";
    private Object logger;

    @Override
    public void init(Configuration config) {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        if (Boolean.FALSE.equals(config.getBooleanProperty(PROP_LOG_ENABLED, true))) {
            LOG.debug("ConfigurationModuleLogging is disabled.");
        } else if (config instanceof ConfigurationImpl) {
            ConfigurationImpl conf = (ConfigurationImpl)config;
            String className = config.getProperty(PROP_LOG_FRAMEWORK_CLASS, PROP_LOG_FRAMEWORK_DEFAULT);
            try {
                Class<?> loggerClass = Class.forName(className);
                this.logger = loggerClass.newInstance();
                Method method = loggerClass.getDeclaredMethod("init", Properties.class);
                method.invoke(this.logger, conf.getProperties());
            }
            catch (Exception e) {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        } else {
            LOG.warn("Unsupported config instance: {}", config.getClass());
        }
    }

    @Override
    public void unload() {
        if (ConfigFactory.getConfigValidator().getBooleanProperty("connector.configurationmodule.logger.unload", false).booleanValue()) {
            LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
            try {
                Method method = this.logger.getClass().getDeclaredMethod("unload", new Class[0]);
                method.invoke(this.logger, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }
}

