/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler.wss4j;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.wss4j.AlgorithmHelper;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPContextAlgorithmHelper
implements AlgorithmHelper {
    private final SOAPMessageContext ctx;

    public SOAPContextAlgorithmHelper(SOAPMessageContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean canHandle(Credential cred) {
        return this.ctx.containsKey((Object)"be.ehealth.technicalconnector.ws.feature.signing");
    }

    @Override
    public String determineDigestAlgo(Credential cred) {
        return (String)this.ctx.get((Object)"digest.method.algorithm");
    }

    @Override
    public String determineSignatureAlgorithm(Credential cred) throws TechnicalConnectorException {
        String algorithm = cred.getPrivateKey().getAlgorithm();
        if ("EC".equals(algorithm)) {
            return (String)this.ctx.get((Object)"ec.signature.method.algorithm");
        }
        if ("RSA".equals(algorithm)) {
            return (String)this.ctx.get((Object)"rsa.signature.method.algorithm");
        }
        throw new IllegalArgumentException("Unsupported algorithm " + cred);
    }
}

