/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security.impl.pkcs11;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.ProviderAdaptor;
import be.ehealth.technicalconnector.shutdown.DeleteFileOnExitShutdownHook;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SunPKCS11ProviderAdaptor
implements ProviderAdaptor {
    private String eidDllLocation;
    private static final Logger LOG = LoggerFactory.getLogger(SunPKCS11ProviderAdaptor.class);
    private static final String PROP_EID_DLL = "eid.dll";
    private static Configuration config = ConfigFactory.getConfigValidator();

    @Override
    public Provider getProvider() throws TechnicalConnectorException {
        try {
            Class<?> sunPKCS11 = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> conSunPKCS11 = sunPKCS11.getDeclaredConstructor(String.class);
            return (Provider)conSunPKCS11.newInstance(this.generateAuthProviderConfig());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String generateAuthProviderConfig() throws TechnicalConnectorException {
        File tmpConfigFile = null;
        PrintWriter configWriter = null;
        try {
            tmpConfigFile = File.createTempFile("pkcs11", "conf");
            DeleteFileOnExitShutdownHook.deleteOnExit(tmpConfigFile);
            configWriter = new PrintWriter(new FileOutputStream(tmpConfigFile), true);
            configWriter.println("name=eIDCard");
            this.eidDllLocation = this.searchEidPath();
            configWriter.println("library=" + this.eidDllLocation);
            LOG.info("library=" + this.eidDllLocation);
            configWriter.println("slotListIndex=0");
            configWriter.println("showInfo=true");
        }
        catch (IOException e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, e.getMessage());
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(configWriter);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)configWriter);
        return tmpConfigFile.getAbsolutePath();
    }

    private String searchEidPath() throws TechnicalConnectorException {
        if (config.hasProperty(PROP_EID_DLL)) {
            String dllPath = config.getProperty(PROP_EID_DLL);
            File f = new File(dllPath);
            if (f.exists()) {
                try {
                    return f.getCanonicalPath();
                }
                catch (IOException e) {
                    LOG.warn("searchEidPath", (Throwable)e);
                }
            } else {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.DLL_NOT_FOUND, PROP_EID_DLL);
            }
        }
        return this.getDefaultEidDllLocation();
    }

    private String getDefaultEidDllLocation() throws TechnicalConnectorException {
        String osName = System.getProperty("os.name");
        String eidPath = osName.startsWith("Linux") ? this.configureLinux() : (osName.startsWith("Mac") ? this.configureMac() : this.configureWindows());
        if (eidPath == null) {
            TechnicalConnectorExceptionValues errorValue = TechnicalConnectorExceptionValues.ERROR_EID_RUNTIME;
            LOG.debug("Unable to determine eid.location" + errorValue.getMessage());
            throw new TechnicalConnectorException(errorValue, (Throwable)null, new Object[0]);
        }
        return eidPath;
    }

    private String configureWindows() throws TechnicalConnectorException {
        String[] libraryDirectories;
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("C:\\WINDOWS\\system32\\beidpkcs11.dll");
        locations.add("C:\\WINDOWS\\system32\\Belgium Identity Card PKCS11.dll");
        locations.add("C:\\WINNT\\system32\\Belgium Identity Card PKCS11.dll");
        locations.add("C:\\WINNT\\system32\\beidpkcs11.dll");
        locations.add("C:\\Windows\\SysWOW64\\beidpkcs11.dll");
        String javaLibraryPath = System.getProperty("java.library.path");
        String pathSeparator = System.getProperty("path.separator");
        for (String libraryDirectory : libraryDirectories = javaLibraryPath.split(pathSeparator)) {
            locations.add(libraryDirectory + "\\beidpkcs11.dll");
        }
        return this.getLocation("Windows", locations);
    }

    private String configureMac() throws TechnicalConnectorException {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("/usr/local/lib/libbeidpkcs11.3.5.1.dylib");
        locations.add("/usr/local/lib/libbeidpkcs11.3.5.0.dylib");
        locations.add("/usr/local/lib/beid-pkcs11.bundle/Contents/MacOS/libbeidpkcs11.2.1.0.dylib");
        locations.add("/usr/local/lib/libbeidpkcs11.dylib");
        locations.add("/usr/local/lib/beid-pkcs11.bundle/Contents/MacOS/libbeidpkcs11.dylib");
        return this.getLocation("Mac", locations);
    }

    private String configureLinux() throws TechnicalConnectorException {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("/usr/local/lib/libbeidpkcs11.so");
        locations.add("/usr/lib/libbeidpkcs11.so");
        locations.add("/usr/local/lib/pkcs11/Belgium-EID-pkcs11.so");
        locations.add("/usr/lib/opensc-pkcs11.so");
        return this.getLocation("Linux", locations);
    }

    private String getLocation(String os, List<String> locations) throws TechnicalConnectorException {
        for (String location : locations) {
            File pkcs11File = new File(location);
            if (!pkcs11File.exists()) continue;
            return pkcs11File.getAbsolutePath();
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.NO_FILE_CONF, os);
    }
}

