/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.security.impl.beid.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.impl.beid.BeIDConnectorGui;
import be.ehealth.technicalconnector.service.sts.security.impl.beid.impl.BeIDConnectorGuiSwing;
import be.ehealth.technicalconnector.utils.PCSCUtils;
import be.ehealth.technicalconnector.utils.SecureString;
import be.fedict.commons.eid.client.PINPurpose;
import be.fedict.commons.eid.client.spi.UserCancelledException;
import java.security.GeneralSecurityException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeIDConnectorExternalGui
implements BeIDConnectorGui {
    public static final String PROP_VERIFY_PIN = "be.ehealth.technicalconnector.service.sts.security.impl.beid.impl.verify_pin";
    private static final Logger LOG = LoggerFactory.getLogger(BeIDConnectorExternalGui.class);
    private BeIDConnectorGui backup = new BeIDConnectorGuiSwing();
    private Map<PINPurpose, SecureString> pincodeMap = new EnumMap<PINPurpose, SecureString>(PINPurpose.class);
    private Integer triesLeft;
    private ConfigValidator config = ConfigFactory.getConfigValidator();

    public static BeIDConnectorExternalGui getInstance() {
        return BeIDConnectorExternalGuiSingleton.INSTANCE.getBeIDConnectorExternalGui();
    }

    private BeIDConnectorExternalGui() {
    }

    public void setLocale(Locale newLocale) {
    }

    public Locale getLocale() {
        return null;
    }

    @Override
    public void advisePINBlocked() {
        this.backup.advisePINBlocked();
    }

    @Override
    public void advisePINChanged() {
        this.backup.advisePINChanged();
    }

    @Override
    public void advisePINPadChangePIN(int arg0) {
        this.backup.advisePINPadChangePIN(arg0);
    }

    @Override
    public void advisePINPadNewPINEntry(int arg0) {
        this.backup.advisePINPadNewPINEntry(arg0);
    }

    @Override
    public void advisePINPadNewPINEntryAgain(int arg0) {
        this.backup.advisePINPadNewPINEntryAgain(arg0);
    }

    @Override
    public void advisePINPadOldPINEntry(int arg0) {
        this.backup.advisePINPadOldPINEntry(arg0);
    }

    @Override
    public void advisePINPadOperationEnd() {
        this.backup.advisePINPadOperationEnd();
    }

    @Override
    public void advisePINPadPUKEntry(int arg0) {
        this.backup.advisePINPadPUKEntry(arg0);
    }

    @Override
    public void advisePINUnblocked() {
        this.backup.advisePINUnblocked();
    }

    @Override
    public void adviseSecureReaderOperation() {
        this.backup.adviseSecureReaderOperation();
    }

    @Override
    public void adviseSecureReaderOperationEnd() {
        this.backup.adviseSecureReaderOperationEnd();
    }

    @Override
    public char[][] obtainOldAndNewPIN(int arg0) {
        return this.backup.obtainOldAndNewPIN(arg0);
    }

    @Override
    public void advisePINPadPINEntry(int arg0, PINPurpose arg1, String arg2) {
        this.backup.advisePINPadPINEntry(arg0, arg1, arg2);
    }

    @Override
    public char[] obtainPIN(int arg0, PINPurpose arg1, String arg2) throws UserCancelledException {
        return this.obtainPIN(arg0, arg1);
    }

    @Override
    public char[] obtainPIN(int triesLeft, PINPurpose type) throws UserCancelledException {
        if (!this.pincodeMap.containsKey(type)) {
            char[] result = this.backup.obtainPIN(triesLeft, type);
            try {
                this.pincodeMap.put(type, new SecureString(result));
            }
            catch (Exception e) {
                LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage(), (Throwable)e);
            }
            return ArrayUtils.clone((char[])result);
        }
        SecureString content = this.pincodeMap.get(type);
        if (this.triesLeft == null) {
            this.triesLeft = triesLeft;
        } else if (this.triesLeft.compareTo(triesLeft) != 0) {
            LOG.warn("Second attempt detected: reseting pincode.");
            this.pincodeMap.remove(type);
            throw new UserCancelledException();
        }
        try {
            if (content == null || content.getValue().length == 0) {
                LOG.error("No pincode detected.");
                throw new UserCancelledException();
            }
            return ArrayUtils.clone((char[])content.getValue());
        }
        catch (Exception e) {
            LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage(), (Throwable)e);
            throw new UserCancelledException();
        }
    }

    @Override
    public char[][] obtainPUKCodes(int arg0) {
        return this.backup.obtainPUKCodes(arg0);
    }

    @Override
    public void advisePINPadPINEntry(int retriesLeft, PINPurpose type) {
        this.backup.advisePINPadPINEntry(retriesLeft, type);
    }

    public void setPIN(PINPurpose pinpurpose, char[] pin) throws TechnicalConnectorException {
        try {
            if ("true".equalsIgnoreCase(this.config.getProperty(PROP_VERIFY_PIN, "true"))) {
                PCSCUtils.verifyPin(ArrayUtils.clone((char[])pin));
            }
            this.pincodeMap.put(pinpurpose, new SecureString(ArrayUtils.clone((char[])pin)));
        }
        catch (GeneralSecurityException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public void setFallbackBeIDConnectorGui(BeIDConnectorGui backup) {
        this.backup = backup;
    }

    private static enum BeIDConnectorExternalGuiSingleton {
        INSTANCE;

        private BeIDConnectorExternalGui instance = new BeIDConnectorExternalGui();

        public BeIDConnectorExternalGui getBeIDConnectorExternalGui() {
            return this.instance;
        }
    }
}

