/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.session.renew;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.renew.AbstractRenewStrategy;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingWindowRenewStrategy
extends AbstractRenewStrategy {
    public static final String SLIDING_WINDOW_SKIP_THRESHOLD = "be.ehealth.technicalconnector.session.renew.SlidingWindowRenewStrategy.threshold";
    public static final String SLIDING_WINDOW_DIVIDER = "be.ehealth.technicalconnector.session.renew.SlidingWindowRenewStrategy.divider";
    private static final Logger LOG = LoggerFactory.getLogger(SlidingWindowRenewStrategy.class);
    private boolean scheduled = false;

    @Override
    public void renew(SessionItem session) throws SessionManagementException {
        if (!this.scheduled) {
            DateTime end = SAMLHelper.getNotOnOrAfterCondition(session.getSAMLToken().getAssertion());
            long delay = SlidingWindowRenewStrategy.calculateDelay(end);
            if (delay > (long)ConfigFactory.getConfigValidator().getIntegerProperty(SLIDING_WINDOW_SKIP_THRESHOLD, 100).intValue()) {
                LOG.debug("Timer scheduled to execute within " + Duration.millis((long)delay).toPeriod().toString());
                Timer reloadTimer = new Timer("SlidingWindowRenewStrategy", true);
                reloadTimer.schedule((TimerTask)new SlidingWindowTimerTask(this, session), delay);
                this.scheduled = true;
            } else {
                LOG.debug("Period too short to start the timer, executing reload now.");
                SlidingWindowRenewStrategy.executeReload(session, this.getCacheServices());
            }
        }
    }

    private void reset() {
        this.scheduled = false;
    }

    private static long calculateDelay(DateTime end) {
        Interval interval = new Interval((ReadableInstant)DateTime.now(), (ReadableInstant)end);
        return interval.toDurationMillis() / (long)ConfigFactory.getConfigValidator().getIntegerProperty(SLIDING_WINDOW_DIVIDER, 2).intValue();
    }

    @Override
    public void flushCache() {
        super.flushCache();
        this.reset();
    }

    private static class SlidingWindowTimerTask
    extends TimerTask {
        private static final Logger LOG = LoggerFactory.getLogger(SlidingWindowTimerTask.class);
        private SlidingWindowRenewStrategy strategy;
        private SessionItem session;

        public SlidingWindowTimerTask(SlidingWindowRenewStrategy strategy, SessionItem session) {
            this.strategy = strategy;
            this.session = session;
        }

        @Override
        public void run() {
            try {
                SlidingWindowRenewStrategy.executeReload(this.session, this.strategy.getCacheServices());
            }
            catch (SessionManagementException e) {
                LOG.error("Unable to renew session", (Throwable)e);
            }
            this.strategy.reset();
        }
    }
}

