/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleClassloader;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleEndpointDistributor;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleLogging;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleOCSP;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleProperties;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleTrustStore;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleVersion;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigurationModuleLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleLoader.class);
    private static final String CONNECTOR_CONFIGMODULES = "connector.configmodule";
    private static List<ConfigurationModule> modulesRegistry = new ArrayList<ConfigurationModule>();

    private ConfigurationModuleLoader() {
        throw new UnsupportedOperationException();
    }

    static void load(Configuration instance) throws TechnicalConnectorException {
        LOG.debug("Loading ConfigurationModule");
        Validate.notNull((Object)instance);
        ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper(CONNECTOR_CONFIGMODULES, null);
        List<ConfigurationModule> modulesToLoad = helper.getImplementations(true, true);
        ConfigurationModuleLoader.filter(modulesToLoad);
        ArrayList<ConfigurationModule> modules = new ArrayList<ConfigurationModule>();
        modules.add(new ConfigurationModuleClassloader());
        modules.add(new ConfigurationModuleLogging());
        modules.add(new ConfigurationModuleVersion());
        modules.add(new ConfigurationModuleProperties());
        modules.addAll(modulesToLoad);
        modules.add(new ConfigurationModuleSecurityProvider());
        modules.add(new ConfigurationModuleTrustStore());
        modules.add(new ConfigurationModuleEndpointDistributor());
        modules.add(new ConfigurationModuleOCSP());
        modulesRegistry.clear();
        for (ConfigurationModule module : modules) {
            if (!Boolean.parseBoolean(System.getProperty("be.ehealth.technicalconnector.config.impl.Configuration.use." + module.getClass().getSimpleName(), "true"))) continue;
            modulesRegistry.add(module);
            module.init(instance);
        }
    }

    static void filter(List<ConfigurationModule> modulesToLoad) {
        CollectionUtils.filter(modulesToLoad, (Predicate)new ConfigurationModulePredicate(ConfigurationModuleClassloader.class, ConfigurationModuleLogging.class, ConfigurationModuleVersion.class, ConfigurationModuleProperties.class, ConfigurationModuleSecurityProvider.class, ConfigurationModuleTrustStore.class, ConfigurationModuleOCSP.class));
    }

    static void unload() {
        for (ConfigurationModule module : modulesRegistry) {
            try {
                module.unload();
            }
            catch (TechnicalConnectorException e) {
                LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage(), (Throwable)e);
            }
        }
    }

    static void unloadSystemProperties(Map<String, String> oldValues) {
        for (Map.Entry<String, String> entry : oldValues.entrySet()) {
            LOG.info("Resetting key [" + entry.getKey() + "] for value[" + entry.getValue() + "]");
            String oldValue = oldValues.get(entry.getKey());
            if (oldValue == null) {
                System.getProperties().remove(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static class ConfigurationModulePredicate
    implements Predicate {
        private Class[] clazz;

        public ConfigurationModulePredicate(Class<? extends ConfigurationModule> ... clazz) {
            this.clazz = clazz;
        }

        public boolean evaluate(Object object) {
            return !ArrayUtils.contains((Object[])this.clazz, object.getClass());
        }
    }
}

