/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl.strategy;

import be.ehealth.technicalconnector.exception.RetryNextEndpointException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.impl.AbstractWsSender;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoRetryInvokeStrategy
extends AbstractWsSender
implements InvokeStrategy {
    private static Logger LOG = LoggerFactory.getLogger(NoRetryInvokeStrategy.class);

    @Override
    public GenericResponse invoke(GenericRequest genericRequest) throws TechnicalConnectorException {
        try {
            return super.call(genericRequest);
        }
        catch (RetryNextEndpointException e) {
            Throwable reason = ExceptionUtils.getRootCause((Throwable)e);
            LOG.error("Cannot send SOAP message. Reason [" + reason + "]", (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, reason);
        }
    }
}

