/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationModuleSSL
implements ConfigurationModule {
    private static final String JAVAX_NET_DEBUG = "javax.net.debug";
    private static final String CONNECTOR_CONFIGURATIONMODULE_SSL_DEBUG = "connector.configurationmodule.ssl.debug";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String TRUSTSTORE_PASSWORD = "truststore_password";
    private static final String KEYSTORE_DIR = "KEYSTORE_DIR";
    private static final String TRUSTSTORE_LOCATION = "truststore_location";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleSSL.class);
    private Map<String, String> oldValues = new HashMap<String, String>();

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        String debugssl;
        LOG.debug("Initializing ConfigurationModule " + this.getClass().getName());
        if (this.isValid(config)) {
            this.oldValues.put(JAVAX_NET_SSL_TRUST_STORE, System.getProperty(JAVAX_NET_SSL_TRUST_STORE));
            this.oldValues.put(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD));
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE, config.getProperty(TRUSTSTORE_LOCATION));
            System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, config.getProperty(TRUSTSTORE_PASSWORD));
        }
        if ("true".equals(debugssl = config.getProperty(CONNECTOR_CONFIGURATIONMODULE_SSL_DEBUG, "false"))) {
            this.oldValues.put(JAVAX_NET_DEBUG, System.getProperty(JAVAX_NET_DEBUG));
            System.setProperty(JAVAX_NET_DEBUG, "all");
        }
        this.verifyTrustStore();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyTrustStore() throws TechnicalConnectorException {
        String trustStoreFilePath = System.getProperty(JAVAX_NET_SSL_TRUST_STORE);
        String location = this.getTrustStoreLocation(trustStoreFilePath);
        if (StringUtils.isEmpty((CharSequence)location)) {
            return;
        }
        InputStream is = null;
        try {
            KeyStore truststore = KeyStore.getInstance("JKS");
            char[] passwordCharArray = new char[]{};
            String password = System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD);
            if (password != null) {
                passwordCharArray = password.toCharArray();
            }
            is = ConnectorIOUtils.getResourceAsStream(location);
            truststore.load(is, passwordCharArray);
            ArrayList<String> aliases = Collections.list(truststore.aliases());
            LOG.debug("Content of truststore at location: " + location);
            for (String alias : aliases) {
                Certificate cert = truststore.getCertificate(alias);
                X509Certificate x509Cert = (X509Certificate)cert;
                String dn = x509Cert.getSubjectX500Principal().getName("RFC2253");
                LOG.debug("\t." + alias + " :" + dn);
            }
        }
        catch (KeyStoreException e) {
            try {
                LOG.warn("KeyStoreException:" + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, (Throwable)e, e.getMessage());
                catch (NoSuchAlgorithmException e2) {
                    LOG.warn("NoSuchAlgorithmException:" + e2.getMessage());
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, (Throwable)e2, e2.getMessage());
                }
                catch (CertificateException e3) {
                    LOG.warn("CertificateException:" + e3.getMessage());
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, (Throwable)e3, e3.getMessage());
                }
                catch (IOException e4) {
                    LOG.warn("IOException:" + e4.getMessage());
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, (Throwable)e4, e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)is);
    }

    private boolean isValid(Configuration config) throws TechnicalConnectorException {
        boolean valid = false;
        String keyStoreDir = config.getProperty(KEYSTORE_DIR);
        String trustStoreName = config.getProperty(TRUSTSTORE_LOCATION);
        if (keyStoreDir == null) {
            LOG.warn("Missing property : KEYSTORE_DIR");
        }
        if (trustStoreName == null) {
            LOG.warn("Missing property : truststore_location");
        }
        if (config.getProperty(TRUSTSTORE_PASSWORD) == null) {
            LOG.warn("Missing property : truststore_password");
        }
        if (keyStoreDir != null && trustStoreName != null) {
            String trustStoreLocation = config.getProperty(KEYSTORE_DIR) + config.getProperty(TRUSTSTORE_LOCATION);
            if ((trustStoreLocation = this.getTrustStoreLocation(trustStoreLocation)) != null) {
                valid = true;
                config.setProperty(TRUSTSTORE_LOCATION, trustStoreLocation);
                if (!trustStoreLocation.equals(config.getProperty(TRUSTSTORE_LOCATION))) {
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "could not update configuration parameter truststore_location : config still returns old location ]" + config.getProperty(TRUSTSTORE_LOCATION) + "[ after update to location ]" + trustStoreLocation + "[");
                }
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getTrustStoreLocation(String trustStoreLocation) {
        String string;
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = ConnectorIOUtils.getResourceAsStream(trustStoreLocation);
            LOG.debug("ConfigurationModuleSSL.getTrustStoreLocation: loading file on location [" + trustStoreLocation + "]");
            if (is == null) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "trustStore file doesn't exist or is not a file on location [" + trustStoreLocation + "] and resourceFilePath [" + trustStoreLocation + "]");
            }
            LOG.debug("Creating new temp trustStore");
            File tempTrust = File.createTempFile(JAVAX_NET_SSL_TRUST_STORE, ".jks");
            tempTrust.deleteOnExit();
            LOG.debug("Creating new temp trustStore on path [" + tempTrust.getPath() + "] with filename [" + tempTrust.getName() + "]");
            fos = new FileOutputStream(tempTrust);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            string = tempTrust.getPath();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            String string2 = null;
            ConnectorIOUtils.closeQuietly(is, fos);
            return string2;
        }
        catch (TechnicalConnectorException e2) {
            LOG.error(e2.getMessage());
            String string3 = null;
            {
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(is, fos);
                    throw throwable;
                }
            }
            ConnectorIOUtils.closeQuietly(is, fos);
            return string3;
        }
        ConnectorIOUtils.closeQuietly(is, fos);
        return string;
    }

    @Override
    public void unload() {
        LOG.debug("Unloading ConfigurationModule " + this.getClass().getName());
        for (String key : this.oldValues.keySet()) {
            LOG.info("Resetting key [" + key + "] for value[" + this.oldValues.get(key) + "]");
            String oldValue = this.oldValues.get(key);
            if (oldValue == null) {
                System.getProperties().remove(key);
                continue;
            }
            System.setProperty(key, oldValue);
        }
    }
}

