/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron.utils;

import be.fgov.ehealth.schematron.utils.LogicalPhysicalMap;
import be.fgov.ehealth.schematron.utils.NamespacePrefixMappings;
import be.fgov.ehealth.schematron.utils.TreeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class LocationAnalyzer
extends DefaultHandler
implements ContentHandler,
LexicalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocationAnalyzer.class);
    private LogicalPhysicalMap locMap;
    private NamespacePrefixMappings nsMap;
    private TreeContext tc = new TreeContext();
    private Locator loc;

    public LocationAnalyzer(LogicalPhysicalMap locMap, NamespacePrefixMappings nsMap) {
        this.locMap = locMap;
        this.nsMap = nsMap;
    }

    @Override
    public void endDocument() throws SAXException {
        LOG.debug("Map enrichment done.");
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        this.tc.onEndElement();
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.loc = loc;
    }

    @Override
    public void startDocument() throws SAXException {
        LOG.debug("Beginning map enrichment");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String regPrefix;
        this.tc.onStartElement(uri, localName);
        this.locMap.handleMapping(this.tc, this.loc);
        if (uri.length() > 0 && (regPrefix = this.nsMap.prefixForNs(uri)) == null) {
            String prefix = null;
            if (qName.indexOf(":") != -1) {
                prefix = qName.substring(0, qName.indexOf(":"));
            }
            if (prefix != null) {
                this.nsMap.registerMapping(prefix, uri);
            } else {
                this.nsMap.registerUnprefixed(uri);
            }
        }
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }
}

