/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.jca.AbstractBeIDPrivateKey;
import be.fedict.commons.eid.jca.BeIDKeyStore;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeIDECPrivateKey
extends AbstractBeIDPrivateKey
implements ECPrivateKey {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BeIDECPrivateKey.class);

    public BeIDECPrivateKey(FileType certificateFileType, BeIDCard beIDCard, boolean logoff, boolean allowFailingLogoff, boolean autoRecovery, BeIDKeyStore beIDKeyStore, String applicationName) {
        super(certificateFileType, beIDCard, logoff, allowFailingLogoff, autoRecovery, beIDKeyStore, applicationName);
    }

    @Override
    public ECParameterSpec getParams() {
        LOGGER.debug("getParams()");
        if (this.authenticationCertificate == null) {
            try {
                this.authenticationCertificate = this.beIDCard.getAuthenticationCertificate();
            }
            catch (IOException | InterruptedException | CertificateException | CardException exception) {
                // empty catch block
            }
        }
        ECPublicKey ecPublicKey = (ECPublicKey)this.authenticationCertificate.getPublicKey();
        return ecPublicKey.getParams();
    }

    @Override
    public BigInteger getS() {
        LOGGER.debug("getS()");
        throw new UnsupportedOperationException();
    }
}

