/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;

class SignerInfoAttributesSender {
    SignerInfoAttributesSender() {
    }

    void addRevocationValues(Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttrs, OCSPData ocspData) throws IOException, CertificateException {
        RevocationValues revocationValues = this.buildRevocationValues(ocspData);
        unsignedAttrs.put(PKCSObjectIdentifiers.id_aa_ets_revocationValues, (ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_ets_revocationValues, (ASN1Set)new DERSet((ASN1Encodable)revocationValues)));
    }

    RevocationValues buildRevocationValues(OCSPData ocspData) throws IOException, CertificateException {
        BasicOCSPResponse[] ocspVals = new BasicOCSPResponse[]{BasicOCSPResponse.getInstance((Object)ASN1Primitive.fromByteArray((byte[])Objects.requireNonNull(ocspData.getOcspResponse())))};
        CertificateList[] crlVals = new CertificateList[ocspData.getCrls().size()];
        int i = 0;
        for (X509CRL crl : ocspData.getCrls()) {
            try {
                crlVals[i++] = CertificateList.getInstance((Object)ASN1Primitive.fromByteArray((byte[])crl.getEncoded()));
            }
            catch (CRLException e) {
                throw new CertificateException("RevocationInfo could not be embedded", e);
            }
        }
        return new RevocationValues(crlVals, ocspVals, null);
    }
}

