package be.fgov.ehealth.technicalconnector.tests.junit.rule;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.ConfigurationFake;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import org.junit.rules.ExternalResource;

import static be.ehealth.technicalconnector.config.ConfigFactory.DEFAULT_CONFIG;

public class ConfigurationFakeRule extends ExternalResource {

    private Configuration configuration;

    @Override
    protected void before() throws Throwable {
        configuration = new ConfigurationFake();
        ConfigFactory.setConfiguration(configuration);
        configuration.reload();
    }

    @Override
    protected void after() {
        ConfigFactory.setConfiguration(null);
        try {
            ConfigFactory.setConfigLocation(DEFAULT_CONFIG);
        } catch (TechnicalConnectorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public void setProperty(String key, String value) {
        configuration.setProperty(key, value);
    }
}
