/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.session;

import java.util.Properties;

import org.junit.BeforeClass;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * Abstract class used in the integration test
 * 
 * @author EHP
 */
public class AbstractSessionManagerIntegrationTest {

    protected static Configuration conf;

    protected static Properties props;

    @BeforeClass
    public static void init() throws Exception {
        props = TestPropertiesLoader.getProperties("/be.ehealth.technicalconnector.test.properties");
        conf = ConfigFactory.getConfigValidator()
                            .getConfig();

        for (Object key : props.keySet()) {
            if (!key.toString()
                    .startsWith("test.")) {
                conf.setProperty(key.toString(), props.getProperty(key.toString()));
            }
        }
    }

}