/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.matchers.BodyMatcher;

public class JsonSchemaMatcher
extends BodyMatcher<String> {
    private final String schema;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "objectMapper"};
    }

    public JsonSchemaMatcher(String schema) {
        this.schema = schema;
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        try {
            ProcessingReport processingReport = this.validateJson(matched);
            if (processingReport.isSuccess()) {
                result = true;
            }
            if (!result) {
                this.logger.trace("Failed to perform JSON match \"{}\" with schema \"{}\" because {}", new Object[]{matched, this.schema, processingReport.toString()});
            }
        }
        catch (Exception e) {
            this.logger.trace("Failed to perform JSON match \"{}\" with \"{}\" because {}", new Object[]{matched, this.schema, e.getMessage()});
        }
        return this.reverseResultIfNot(result);
    }

    public ProcessingReport validateJson(String json) throws Exception {
        return JsonSchemaFactory.byDefault().getValidator().validate(this.objectMapper.readTree(this.schema), this.objectMapper.readTree(json), true);
    }
}

