/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron.domain;

import be.fgov.ehealth.schematron.utils.EnrichmentFilter;
import be.fgov.ehealth.schematron.utils.LocationAnalyzer;
import be.fgov.ehealth.schematron.utils.LogicalPhysicalMap;
import be.fgov.ehealth.schematron.utils.NamespacePrefixMappings;
import be.fgov.ehealth.schematron.utils.SVRLXMLWriter;
import be.fgov.ehealth.schematron.utils.SvrlHarvestHandler;
import be.fgov.ehealth.schematron.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SchematronOutput;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SchematronResult {
    private static final Logger LOG = LoggerFactory.getLogger(SchematronResult.class);
    private static final JAXBContext ctx;
    private final LogicalPhysicalMap locMap = new LogicalPhysicalMap();
    private final NamespacePrefixMappings nsMap = new NamespacePrefixMappings();
    private final byte[] svrl;
    private final SchematronOutput schematronOutput;
    private File input;

    public SchematronResult(String inSvrl) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)inSvrl));
        inSvrl = XmlUtils.removeProcessInstruction(inSvrl);
        try {
            this.svrl = inSvrl.getBytes("UTF-8");
            this.schematronOutput = (SchematronOutput)ctx.createUnmarshaller().unmarshal((Source)new StreamSource(new ByteArrayInputStream(this.svrl)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String sanitize(String string) {
        return StringUtils.trimToEmpty((String)string).replaceAll("\t", "").replaceAll("\n", "").replaceAll("\r", "").trim();
    }

    public void setInput(File input) {
        this.input = input;
    }

    public boolean isValid() {
        for (FailedAssert failedAssert : this.schematronOutput.getFailedAssert()) {
            if (!Arrays.asList("FATAL", "ERROR").contains(failedAssert.getRole())) continue;
            return false;
        }
        return true;
    }

    public byte[] getSVRLAsBytes(boolean annotated) {
        if (annotated) {
            return this.annotateWithLocators(this.svrl, this.input);
        }
        return this.svrl;
    }

    public SchematronOutput getSVRL() throws JAXBException {
        return (SchematronOutput)ctx.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(this.svrl));
    }

    public String getSVRLAsString() {
        try {
            return new String(this.svrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String[] getFailedMessages() {
        ArrayList<String> result = new ArrayList<String>();
        for (FailedAssert failedAssert : this.schematronOutput.getFailedAssert()) {
            result.add("[assert] " + failedAssert.getLocation() + " - " + SchematronResult.sanitize(failedAssert.getText()));
        }
        return result.toArray(new String[0]);
    }

    public String[] getReportMessages() {
        ArrayList<String> result = new ArrayList<String>();
        for (SuccessfulReport report : this.schematronOutput.getSuccessfulReport()) {
            result.add("[report] " + report.getLocation() + " - " + SchematronResult.sanitize(report.getText()));
        }
        return result.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] annotateWithLocators(byte[] svrl, File input) {
        ByteArrayOutputStream baos = null;
        FileInputStream is = null;
        ByteArrayInputStream bais = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(new SvrlHarvestHandler(this.locMap, this.nsMap));
            parser.parse(new InputSource(new ByteArrayInputStream(svrl)));
            parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(new LocationAnalyzer(this.locMap, this.nsMap));
            is = new FileInputStream(input);
            parser.parse(new InputSource(is));
            LOG.debug("Mapped " + this.locMap.size() + " XPaths to physical locations");
            XMLReader reader = XMLReaderFactory.createXMLReader();
            EnrichmentFilter filter = new EnrichmentFilter(this.locMap, this.nsMap);
            filter.setParent(reader);
            baos = new ByteArrayOutputStream();
            filter.setContentHandler(new SVRLXMLWriter(new OutputStreamWriter(baos)));
            bais = new ByteArrayInputStream(svrl);
            filter.parse(new InputSource(bais));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOG.error("Unable to enrich with locations", (Throwable)e);
            byte[] byArray = svrl;
            return byArray;
        }
    }

    static {
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{SchematronOutput.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

