/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.NoNextEndpointException;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointDistributor {
    public static final String PROP_POLLING_INTERVAL = "be.fgov.ehealth.technicalconnector.bootstrap.bcp.polling.interval.minutes";
    public static final String PROP_POLLING_ACTIVATED = "be.fgov.ehealth.technicalconnector.bootstrap.bcp.polling.activated";
    private static final long DEFAULT_POLLING_INTERVAL = 15L;
    private static final Logger LOG = LoggerFactory.getLogger(EndpointDistributor.class);
    private static ConfigValidator config = ConfigFactory.getConfigValidator();
    private boolean polling;
    private Timer timer;
    private Map<String, String> url2Service = new HashMap<String, String>();
    private Map<String, List<String>> service2AllEndpoints = new HashMap<String, List<String>>();
    private Map<String, String> service2ActiveEndpoint = new HashMap<String, String>();
    private Map<String, String> service2DefaultEndpoint = new HashMap<String, String>();
    private Map<String, CacheInformation> service2CacheInformation = new HashMap<String, CacheInformation>();

    public static EndpointDistributor getInstance() {
        return EndpointDistributorSingleton.INSTANCE.getEndpointDistributor();
    }

    private EndpointDistributor() {
    }

    public String getService(String currentEndpoint) {
        return this.url2Service.get(currentEndpoint);
    }

    public String getActiveEndpoint(String currentEndpoint) {
        if (this.url2Service.containsKey(currentEndpoint)) {
            return this.service2ActiveEndpoint.get(this.url2Service.get(currentEndpoint));
        }
        return currentEndpoint;
    }

    public boolean mustCache(String currentEndpoint) {
        String service = this.url2Service.get(currentEndpoint);
        if (StringUtils.isNotEmpty((CharSequence)service)) {
            return this.service2CacheInformation.containsKey(service);
        }
        return false;
    }

    public CacheInformation getCacheInformation(String currentEndpoint) {
        return this.service2CacheInformation.get(this.url2Service.get(currentEndpoint));
    }

    public void activatePolling() {
        if (!this.polling && this.isBCPMode() && config.getBooleanProperty(PROP_POLLING_ACTIVATED, Boolean.TRUE).booleanValue()) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new StatusPollingTimerTask(), new Date(), TimeUnit.MILLISECONDS.convert(config.getLongProperty(PROP_POLLING_INTERVAL, 15L), TimeUnit.MINUTES));
        }
        this.polling = true;
    }

    public boolean mustPoll() {
        return this.polling;
    }

    public void activateNextEndPoint(String currentEndpoint) throws NoNextEndpointException {
        LOG.debug("Trying to activate next endpoint for [{}]", (Object)currentEndpoint);
        if (!this.url2Service.containsKey(currentEndpoint)) {
            throw new NoNextEndpointException("Unable to activate alternative for [" + currentEndpoint + "]");
        }
        String serviceKey = this.url2Service.get(currentEndpoint);
        String nextEndpoint = EndpointDistributor.next(currentEndpoint, this.service2AllEndpoints.get(serviceKey));
        LOG.info("Activating new endpoint [{}] for [{}]", (Object)nextEndpoint, (Object)serviceKey);
        this.service2ActiveEndpoint.put(serviceKey, nextEndpoint);
    }

    public int getAmountOfAlternatives(String currentEndpoint) {
        if (this.url2Service.containsKey(currentEndpoint)) {
            String serviceKey = this.url2Service.get(currentEndpoint);
            return this.service2AllEndpoints.get(serviceKey).size();
        }
        return 1;
    }

    private static String next(String currentEndpoint, List<String> endpoints) throws NoNextEndpointException {
        Validate.notEmpty(endpoints);
        if (endpoints.size() == 1) {
            throw new NoNextEndpointException("Unable to activate alternative for [" + currentEndpoint + "]");
        }
        Validate.isTrue((endpoints.size() > 1 ? 1 : 0) != 0);
        int pos = endpoints.indexOf(currentEndpoint);
        if (pos == -1) {
            throw new IllegalArgumentException("Unable to find currentValue [" + currentEndpoint + "] in list " + StringUtils.join(endpoints, (String)","));
        }
        int next = ++pos;
        return endpoints.size() == next ? endpoints.get(0) : endpoints.get(next);
    }

    public void update(EndPointInformation info) {
        Validate.notNull((Object)info);
        if (!EndpointDistributor.isBCPMode(info)) {
            this.polling = false;
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        this.url2Service = info.getUrl2Service();
        this.service2ActiveEndpoint = new HashMap<String, String>(info.getService2ActiveEndpoint());
        this.service2AllEndpoints = info.getService2AllEndpoints();
        this.service2DefaultEndpoint = info.getService2DefaultEndpoint();
        this.service2CacheInformation = info.getService2CacheInformation();
    }

    protected void reset() {
        this.url2Service = new HashMap<String, String>();
        this.service2AllEndpoints = new HashMap<String, List<String>>();
        this.service2ActiveEndpoint = new HashMap<String, String>();
        this.service2DefaultEndpoint = new HashMap<String, String>();
    }

    private static boolean isBCPMode(EndPointInformation info) {
        return !info.getService2ActiveEndpoint().equals(info.getService2DefaultEndpoint());
    }

    private boolean isBCPMode() {
        return !this.service2ActiveEndpoint.equals(this.service2DefaultEndpoint);
    }

    public static boolean update() {
        try {
            return (Boolean)MethodUtils.invokeStaticMethod(Class.forName("be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointUpdater"), (String)"update", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Unable to update endpoints", (Throwable)e);
            return false;
        }
    }

    private static class StatusPollingTimerTask
    extends TimerTask {
        private static final Logger LOG = LoggerFactory.getLogger(StatusPollingTimerTask.class);

        private StatusPollingTimerTask() {
        }

        @Override
        public void run() {
            LOG.debug("Update endpoints through Timer");
            EndpointDistributor.update();
        }
    }

    private static enum EndpointDistributorSingleton {
        INSTANCE;

        private volatile EndpointDistributor distributor = new EndpointDistributor();

        public EndpointDistributor getEndpointDistributor() {
            return this.distributor;
        }
    }
}

