/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.ExpectationDTO;
import org.mockserver.mock.Expectation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectationSerializer
implements Serializer<Expectation> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    @Override
    public String serialize(Expectation expectation) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new ExpectationDTO(expectation));
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while serializing expectation to JSON with value %s", expectation), (Throwable)e);
            throw new RuntimeException(String.format("Exception while serializing expectation to JSON with value %s", expectation), e);
        }
    }

    @Override
    public String serialize(Expectation[] expectation) {
        try {
            if (expectation != null && expectation.length > 0) {
                ExpectationDTO[] expectationDTOs = new ExpectationDTO[expectation.length];
                for (int i = 0; i < expectation.length; ++i) {
                    expectationDTOs[i] = new ExpectationDTO(expectation[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)expectationDTOs);
            }
            return "";
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing expectation to JSON with value " + Arrays.asList(expectation), (Throwable)e);
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectation), e);
        }
    }

    @Override
    public Expectation deserialize(String jsonExpectation) {
        if (jsonExpectation == null || jsonExpectation.isEmpty()) {
            throw new IllegalArgumentException("Expected an JSON Expectation object but http body is empty");
        }
        Expectation expectation = null;
        try {
            ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonExpectation, ExpectationDTO.class);
            if (expectationDTO != null) {
                expectation = expectationDTO.buildObject();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while parsing response [" + jsonExpectation + "] for Expectation", (Throwable)e);
            throw new RuntimeException("Exception while parsing response [" + jsonExpectation + "] for Expectation", e);
        }
        return expectation;
    }

    @Override
    public Class<Expectation> supportsType() {
        return Expectation.class;
    }

    public Expectation[] deserializeArray(String jsonExpectations) {
        Expectation[] expectations = new Expectation[]{};
        if (jsonExpectations != null && !jsonExpectations.isEmpty()) {
            try {
                ExpectationDTO[] expectationDTOs = (ExpectationDTO[])this.objectMapper.readValue(jsonExpectations, ExpectationDTO[].class);
                if (expectationDTOs != null && expectationDTOs.length > 0) {
                    expectations = new Expectation[expectationDTOs.length];
                    for (int i = 0; i < expectationDTOs.length; ++i) {
                        expectations[i] = expectationDTOs[i].buildObject();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while parsing response [" + jsonExpectations + "] for Expectation[]", (Throwable)e);
                throw new RuntimeException("Exception while parsing response [" + jsonExpectations + "] for Expectation[]", e);
            }
        }
        return expectations;
    }
}

