/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client;

import be.fedict.commons.eid.client.BeIDCardManager;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.client.PINPurpose;
import be.fedict.commons.eid.client.ResponseAPDUException;
import be.fedict.commons.eid.client.event.BeIDCardListener;
import be.fedict.commons.eid.client.impl.BeIDDigest;
import be.fedict.commons.eid.client.impl.CCID;
import be.fedict.commons.eid.client.impl.LocaleManager;
import be.fedict.commons.eid.client.impl.VoidLogger;
import be.fedict.commons.eid.client.spi.BeIDCardUI;
import be.fedict.commons.eid.client.spi.Logger;
import be.fedict.commons.eid.client.spi.UserCancelledException;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class BeIDCard {
    private static final String UI_MISSING_LOG_MESSAGE = "No BeIDCardUI set and can't load DefaultBeIDCardUI";
    private static final String UI_DEFAULT_REQUIRES_HEAD = "No BeIDCardUI set and DefaultBeIDCardUI requires a graphical environment";
    private static final String DEFAULT_UI_IMPLEMENTATION = "be.fedict.commons.eid.dialogs.DefaultBeIDCardUI";
    private static final byte[] BELPIC_AID = new byte[]{-96, 0, 0, 1, 119, 80, 75, 67, 83, 45, 49, 53};
    private static final byte[] APPLET_AID = new byte[]{-96, 0, 0, 0, 48, 41, 5, 112, 0, -83, 19, 16, 1, 1, -1};
    private static final int BLOCK_SIZE = 255;
    private final CardChannel cardChannel;
    private final List<BeIDCardListener> cardListeners;
    private final CertificateFactory certificateFactory;
    private final KeyFactory keyFactory;
    private final Card card;
    private final Logger logger;
    private CCID ccid;
    private BeIDCardUI ui;
    private CardTerminal cardTerminal;
    private Locale locale;
    private Thread exclusiveAccessThread;

    public BeIDCard(Card card, Logger logger) {
        this.card = card;
        this.cardChannel = card.getBasicChannel();
        if (null == logger) {
            throw new IllegalArgumentException("logger expected");
        }
        this.logger = logger;
        this.cardListeners = new LinkedList<BeIDCardListener>();
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
            this.keyFactory = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("algo", e);
        }
    }

    public BeIDCard(Card card) {
        this(card, (Logger)new VoidLogger());
    }

    public BeIDCard(CardTerminal cardTerminal, Logger logger) throws CardException {
        this(cardTerminal.connect("T=0"), logger);
    }

    public BeIDCard(CardTerminal cardTerminal) throws CardException {
        this(cardTerminal.connect("T=0"), null);
        this.setCardTerminal(cardTerminal);
    }

    public BeIDCard close() {
        this.logger.debug("closing eID card");
        this.setCardTerminal(null);
        try {
            this.card.disconnect(true);
        }
        catch (CardException e) {
            this.logger.error("could not disconnect the card: " + e.getMessage());
        }
        return this;
    }

    public final BeIDCard setUI(BeIDCardUI userInterface) {
        this.ui = userInterface;
        if (this.locale == null) {
            this.setLocale(userInterface.getLocale());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BeIDCard addCardListener(BeIDCardListener beIDCardListener) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            this.cardListeners.add(beIDCardListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BeIDCard removeCardListener(BeIDCardListener beIDCardListener) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            this.cardListeners.remove(beIDCardListener);
        }
        return this;
    }

    public X509Certificate getCertificate(FileType fileType) throws CertificateException, CardException, IOException, InterruptedException {
        return (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(this.readFile(fileType)));
    }

    public X509Certificate getAuthenticationCertificate() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificate(FileType.AuthentificationCertificate);
    }

    public X509Certificate getSigningCertificate() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificate(FileType.NonRepudiationCertificate);
    }

    public X509Certificate getCACertificate() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificate(FileType.CACertificate);
    }

    public X509Certificate getRootCACertificate() throws CertificateException, CardException, IOException, InterruptedException {
        return this.getCertificate(FileType.RootCertificate);
    }

    public X509Certificate getRRNCertificate() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificate(FileType.RRNCertificate);
    }

    public List<X509Certificate> getCertificateChain(FileType fileType) throws CertificateException, CardException, IOException, InterruptedException {
        LinkedList<X509Certificate> chain = new LinkedList<X509Certificate>();
        chain.add((X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(this.readFile(fileType))));
        if (fileType.chainIncludesCitizenCA()) {
            chain.add((X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(this.readFile(FileType.CACertificate))));
        }
        chain.add((X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(this.readFile(FileType.RootCertificate))));
        return chain;
    }

    public List<byte[]> getRawCertificateChain(FileType fileType) throws CardException, IOException, InterruptedException {
        LinkedList<byte[]> certificateChain = new LinkedList<byte[]>();
        certificateChain.add(this.readFile(fileType));
        if (fileType.chainIncludesCitizenCA()) {
            certificateChain.add(this.readFile(FileType.CACertificate));
        }
        certificateChain.add(this.readFile(FileType.RootCertificate));
        return certificateChain;
    }

    public List<X509Certificate> getAuthenticationCertificateChain() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificateChain(FileType.AuthentificationCertificate);
    }

    public List<byte[]> getRawAuthenticationCertificateChain() throws CardException, IOException, InterruptedException {
        return this.getRawCertificateChain(FileType.AuthentificationCertificate);
    }

    public List<X509Certificate> getSigningCertificateChain() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificateChain(FileType.NonRepudiationCertificate);
    }

    public List<byte[]> getRawSigningCertificateChain() throws CardException, IOException, InterruptedException {
        return this.getRawCertificateChain(FileType.NonRepudiationCertificate);
    }

    public List<X509Certificate> getCACertificateChain() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificateChain(FileType.CACertificate);
    }

    public List<X509Certificate> getRRNCertificateChain() throws CardException, IOException, CertificateException, InterruptedException {
        return this.getCertificateChain(FileType.RRNCertificate);
    }

    public List<byte[]> getRawRRNCertificateChain() throws CardException, IOException, InterruptedException {
        return this.getRawCertificateChain(FileType.RRNCertificate);
    }

    public ECPublicKey getBasicPublicKey() throws CardException, IOException, InterruptedException, InvalidKeySpecException {
        byte[] basicPublicFile = this.readFile(FileType.BasicPublic);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(basicPublicFile);
        return (ECPublicKey)this.keyFactory.generatePublic(publicKeySpec);
    }

    public byte[] sign(byte[] digestValue, BeIDDigest digestAlgo, FileType fileType, boolean requireSecureReader) throws CardException, IOException, InterruptedException, UserCancelledException {
        return this.sign(digestValue, digestAlgo, fileType, requireSecureReader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(byte[] digestValue, BeIDDigest digestAlgo, FileType fileType, boolean requireSecureReader, String applicationName) throws CardException, IOException, InterruptedException, UserCancelledException {
        if (!fileType.isCertificateUserCanSignWith()) {
            throw new IllegalArgumentException("Not a certificate that can be used for signing: " + fileType.name());
        }
        if (this.isEC() ? !digestAlgo.isEc() : digestAlgo.isEc()) {
            throw new IllegalArgumentException("unsupported algorithm: " + (Object)((Object)digestAlgo));
        }
        if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
            this.logger.debug("eID-aware secure PIN pad reader detected");
        }
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT) && this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_START)) {
            throw new SecurityException("not a secure reader");
        }
        this.beginExclusive();
        this.notifySigningBegin(fileType);
        try {
            this.logger.debug("selecting key...");
            ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_ALGORITHM_AND_PRIVATE_KEY, new byte[]{4, -128, digestAlgo.getAlgorithmReference(), -124, fileType.getKeyId()});
            if (36864 != responseApdu.getSW()) {
                throw new ResponseAPDUException("SET (select algorithm and private key) error", responseApdu);
            }
            if (FileType.NonRepudiationCertificate.getKeyId() == fileType.getKeyId()) {
                this.logger.debug("non-repudiation key detected, immediate PIN verify");
                this.verifyPin(PINPurpose.NonRepudiationSignature, applicationName);
            }
            ByteArrayOutputStream digestInfo = new ByteArrayOutputStream();
            digestInfo.write(digestAlgo.getPrefix(digestValue.length));
            digestInfo.write(digestValue);
            this.logger.debug("computing digital signature...");
            responseApdu = this.transmitCommand(BeIDCommandAPDU.COMPUTE_DIGITAL_SIGNATURE, digestInfo.toByteArray());
            if (36864 == responseApdu.getSW()) {
                if (digestAlgo.isEc()) {
                    byte[] byArray = this.toDERSignature(responseApdu.getData());
                    return byArray;
                }
                byte[] byArray = responseApdu.getData();
                return byArray;
            }
            if (27010 != responseApdu.getSW()) {
                this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
                throw new ResponseAPDUException("compute digital signature error", responseApdu);
            }
            this.logger.debug("PIN verification required...");
            this.verifyPin(PINPurpose.fromFileType(fileType), applicationName);
            this.logger.debug("computing digital signature (attempt #2 after PIN verification)...");
            responseApdu = this.transmitCommand(BeIDCommandAPDU.COMPUTE_DIGITAL_SIGNATURE, digestInfo.toByteArray());
            if (36864 != responseApdu.getSW()) {
                throw new ResponseAPDUException("compute digital signature error", responseApdu);
            }
            if (digestAlgo.isEc()) {
                byte[] byArray = this.toDERSignature(responseApdu.getData());
                return byArray;
            }
            byte[] byArray = responseApdu.getData();
            return byArray;
        }
        finally {
            this.endExclusive();
            this.notifySigningEnd(fileType);
        }
    }

    public byte[] signAuthn(byte[] toBeSigned, boolean requireSecureReader) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        return this.signAuthn(toBeSigned, requireSecureReader, null);
    }

    public byte[] signAuthn(byte[] toBeSigned, boolean requireSecureReader, String applicationName) throws NoSuchAlgorithmException, CardException, IOException, InterruptedException, UserCancelledException {
        MessageDigest messageDigest = BeIDDigest.SHA_1.getMessageDigestInstance();
        byte[] digest = messageDigest.digest(toBeSigned);
        return this.sign(digest, BeIDDigest.SHA_1, FileType.AuthentificationCertificate, requireSecureReader, applicationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] internalAuthenticate(byte[] challenge) throws CardException {
        if (challenge.length != 48) {
            throw new IllegalArgumentException("challenge size incorrect");
        }
        this.beginExclusive();
        try {
            ResponseAPDU setResponseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_ALGORITHM_AND_PRIVATE_KEY, new byte[]{4, -128, 2, -124, FileType.BasicPublic.getKeyId()});
            if (36864 != setResponseApdu.getSW()) {
                throw new ResponseAPDUException("SET (select algorithm and private key) error", setResponseApdu);
            }
            byte[] data = new byte[challenge.length + 2];
            data[0] = -108;
            data[1] = (byte)challenge.length;
            System.arraycopy(challenge, 0, data, 2, challenge.length);
            ResponseAPDU intAuthnResponseApdu = this.transmitCommand(BeIDCommandAPDU.INTERNAL_AUTHENTICATE, data);
            if (36864 != intAuthnResponseApdu.getSW()) {
                throw new RuntimeException("INTERNAL AUTHENTICATE failed: " + Integer.toHexString(intAuthnResponseApdu.getSW()));
            }
            byte[] byArray = this.toDERSignature(intAuthnResponseApdu.getData());
            return byArray;
        }
        finally {
            this.endExclusive();
        }
    }

    public void verifyPin() throws IOException, CardException, InterruptedException, UserCancelledException {
        this.verifyPin(null);
    }

    public void verifyPin(String applicationName) throws IOException, CardException, InterruptedException, UserCancelledException {
        this.verifyPin(PINPurpose.PINTest, applicationName);
    }

    public void changePin(boolean requireSecureReader) throws Exception {
        ResponseAPDU responseApdu;
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_DIRECT) && !this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_START)) {
            throw new SecurityException("not a secure reader");
        }
        int retriesLeft = -1;
        do {
            if (this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_START)) {
                this.logger.debug("using modify pin start/finish...");
                responseApdu = this.changePINViaCCIDStartFinish(retriesLeft);
            } else if (this.getCCID().hasFeature(CCID.FEATURE.MODIFY_PIN_DIRECT)) {
                this.logger.debug("could use direct PIN modify here...");
                responseApdu = this.changePINViaCCIDDirect(retriesLeft);
            } else {
                responseApdu = this.changePINViaUI(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.logger.debug("CHANGE PIN error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN change error. Card blocked?");
                throw new ResponseAPDUException("PIN Change Error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.getUI().advisePINChanged();
    }

    public byte[] getChallenge(int size) throws CardException {
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.GET_CHALLENGE, new byte[0], 0, 0, size);
        if (36864 != responseApdu.getSW()) {
            this.logger.debug("get challenge failure: " + Integer.toHexString(responseApdu.getSW()));
            throw new ResponseAPDUException("get challenge failure: " + Integer.toHexString(responseApdu.getSW()), responseApdu);
        }
        if (size != responseApdu.getData().length) {
            throw new RuntimeException("challenge size incorrect: " + responseApdu.getData().length);
        }
        return responseApdu.getData();
    }

    public byte[] signTransactionMessage(String transactionMessage, boolean requireSecureReader) throws CardException, IOException, InterruptedException, UserCancelledException {
        return this.signTransactionMessage(transactionMessage, requireSecureReader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signTransactionMessage(String transactionMessage, boolean requireSecureReader, String applicationName) throws CardException, IOException, InterruptedException, UserCancelledException {
        byte[] signature;
        if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
            this.getUI().adviseSecureReaderOperation();
        }
        try {
            signature = this.sign(transactionMessage.getBytes(), BeIDDigest.PLAIN_TEXT, FileType.AuthentificationCertificate, requireSecureReader, applicationName);
        }
        finally {
            if (this.getCCID().hasFeature(CCID.FEATURE.EID_PIN_PAD_READER)) {
                this.getUI().adviseSecureReaderOperationEnd();
            }
        }
        return signature;
    }

    public BeIDCard logoff() throws Exception {
        CommandAPDU logoffApdu = new CommandAPDU(128, 230, 0, 0);
        this.logger.debug("logoff...");
        ResponseAPDU responseApdu = this.transmit(logoffApdu);
        if (36864 != responseApdu.getSW()) {
            throw new RuntimeException("logoff failed");
        }
        return this;
    }

    public void unblockPin(boolean requireSecureReader) throws Exception {
        ResponseAPDU responseApdu;
        if (requireSecureReader && !this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT)) {
            throw new SecurityException("not a secure reader");
        }
        int retriesLeft = -1;
        do {
            if (this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT)) {
                this.logger.debug("could use direct PIN verify here...");
                responseApdu = this.unblockPINViaCCIDVerifyPINDirectOfPUK(retriesLeft);
            } else {
                responseApdu = this.unblockPINViaUI(retriesLeft);
            }
            if (36864 == responseApdu.getSW()) continue;
            this.logger.debug("PIN unblock error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN unblock error.");
                throw new ResponseAPDUException("PIN unblock error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
        this.getUI().advisePINUnblocked();
    }

    public ATR getATR() {
        return this.card.getATR();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return LocaleManager.getLocale();
    }

    public BeIDCard setLocale(Locale newLocale) {
        this.locale = newLocale;
        if (this.locale != null && this.ui != null) {
            this.ui.setLocale(this.locale);
        }
        return this;
    }

    public BeIDCard selectApplet() throws CardException {
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_APPLET, BELPIC_AID);
        if (36864 != responseApdu.getSW()) {
            this.logger.error("error selecting BELPIC");
            this.logger.debug("status word: " + Integer.toHexString(responseApdu.getSW()));
            try {
                responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_APPLET, APPLET_AID);
            }
            catch (CardException e) {
                this.logger.error("error selecting Applet");
                return this;
            }
            if (36864 != responseApdu.getSW()) {
                this.logger.error("could not select applet");
            } else {
                this.logger.debug("BELPIC JavaCard applet selected by APPLET_AID");
            }
        } else {
            this.logger.debug("BELPIC JavaCard applet selected by BELPIC_AID");
        }
        return this;
    }

    public BeIDCard beginExclusive() throws CardException {
        this.logger.debug("---begin exclusive---");
        if (this.exclusiveAccessThread != null) {
            throw new IllegalStateException("Exclusive access already granted to " + this.exclusiveAccessThread.getName());
        }
        this.card.beginExclusive();
        this.exclusiveAccessThread = Thread.currentThread();
        return this;
    }

    public BeIDCard endExclusive() throws CardException {
        this.logger.debug("---end exclusive---");
        if (Thread.currentThread() != this.exclusiveAccessThread) {
            return this;
        }
        try {
            this.exclusiveAccessThread = null;
            this.card.endExclusive();
        }
        catch (CardException e) {
            this.logger.error("end exclusive failed: " + e.getMessage());
        }
        return this;
    }

    public byte[] readBinary(FileType fileType, int estimatedMaxSize) throws CardException, IOException, InterruptedException {
        byte[] data;
        int offset = 0;
        this.logger.debug("read binary");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("interrupted in readBinary");
                throw new InterruptedException();
            }
            this.notifyReadProgress(fileType, offset, estimatedMaxSize);
            ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.READ_BINARY, offset >> 8, offset & 0xFF, 255);
            int sw = responseApdu.getSW();
            if (27392 == sw) break;
            if (36864 != sw) {
                IOException ioEx = new IOException("BeIDCommandAPDU response error: " + responseApdu.getSW(), new ResponseAPDUException(responseApdu));
                throw ioEx;
            }
            data = responseApdu.getData();
            baos.write(data);
            offset += data.length;
        } while (255 == data.length);
        this.notifyReadProgress(fileType, offset, offset);
        return baos.toByteArray();
    }

    public BeIDCard selectFile(byte[] fileId) throws CardException, FileNotFoundException {
        this.logger.debug("selecting file");
        ResponseAPDU responseApdu = this.transmitCommand(BeIDCommandAPDU.SELECT_FILE, fileId);
        if (36864 != responseApdu.getSW()) {
            FileNotFoundException fnfEx = new FileNotFoundException("wrong status word after selecting file: " + Integer.toHexString(responseApdu.getSW()));
            fnfEx.initCause(new ResponseAPDUException(responseApdu));
            throw fnfEx;
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("sleep error: " + e.getMessage());
        }
        return this;
    }

    public byte[] readFile(FileType fileType) throws CardException, IOException, InterruptedException {
        this.beginExclusive();
        try {
            this.selectFile(fileType.getFileId());
            byte[] byArray = this.readBinary(fileType, fileType.getEstimatedMaxSize());
            return byArray;
        }
        finally {
            this.endExclusive();
        }
    }

    public boolean cardTerminalHasCCIDFeature(CCID.FEATURE feature) {
        return this.getCCID().hasFeature(feature);
    }

    public byte[] getCardData() throws CardException, FileNotFoundException {
        BeIDCommandAPDU apdu = this.isEC() ? BeIDCommandAPDU.GET_CARD_DATA_1_8 : BeIDCommandAPDU.GET_CARD_DATA;
        ResponseAPDU responseApdu = this.transmitCommand(apdu, 255);
        if (36864 != responseApdu.getSW()) {
            throw new FileNotFoundException("GET CARD DATA ERROR: " + Integer.toHexString(responseApdu.getSW()));
        }
        return responseApdu.getData();
    }

    public boolean isEC() {
        return BeIDCardManager.matches18ATR(this.card.getATR());
    }

    protected byte[] transmitCCIDControl(boolean usePPDU, CCID.FEATURE feature) throws CardException {
        return this.transmitControlCommand(this.getCCID().getFeature(feature), new byte[0]);
    }

    protected byte[] transmitCCIDControl(boolean usePPDU, CCID.FEATURE feature, byte[] command) throws CardException {
        if (usePPDU) {
            return this.transmitPPDUCommand(feature.getTag(), command);
        }
        return this.transmitControlCommand(this.getCCID().getFeature(feature), command);
    }

    protected byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
        return this.card.transmitControlCommand(controlCode, command);
    }

    protected byte[] transmitPPDUCommand(int controlCode, byte[] command) throws CardException {
        ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.PPDU, controlCode, command);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("PPDU Command Failed: ResponseAPDU=" + responseAPDU.getSW());
        }
        if (responseAPDU.getNr() == 0) {
            return responseAPDU.getBytes();
        }
        return responseAPDU.getData();
    }

    protected ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int le) throws CardException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), le));
    }

    protected ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int p2, byte[] data) throws CardException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), p2, data));
    }

    protected ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, int p1, int p2, int le) throws CardException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), p1, p2, le));
    }

    protected ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, byte[] data) throws CardException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), data));
    }

    protected ResponseAPDU transmitCommand(BeIDCommandAPDU apdu, byte[] data, int dataOffset, int dataLength, int ne) throws CardException {
        return this.transmit(new CommandAPDU(apdu.getCla(), apdu.getIns(), apdu.getP1(), apdu.getP2(), data, dataOffset, dataLength, ne));
    }

    private ResponseAPDU transmit(CommandAPDU commandApdu) throws CardException {
        return this.transmit(commandApdu, 0);
    }

    private ResponseAPDU transmit(CommandAPDU commandApdu, int attempt) throws CardException {
        if (attempt >= 32) {
            throw new CardException("Could not obtain response.");
        }
        ResponseAPDU responseApdu = this.cardChannel.transmit(commandApdu);
        if (108 == responseApdu.getSW1()) {
            this.logger.debug("sleeping...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("cannot sleep");
            }
            CommandAPDU newCommandApdu = new CommandAPDU(commandApdu.getCLA(), commandApdu.getINS(), commandApdu.getP1(), commandApdu.getP2(), commandApdu.getData(), responseApdu.getSW2());
            responseApdu = this.transmit(newCommandApdu, attempt + 1);
        } else if (97 == responseApdu.getSW1()) {
            int le = responseApdu.getSW2();
            if (le == 0) {
                le = 255;
            }
            CommandAPDU newCommandApdu = new CommandAPDU(0, 192, 0, 0, le);
            ResponseAPDU newResponseApdu = this.transmit(newCommandApdu, attempt + 1);
            byte[] oldData = responseApdu.getData();
            byte[] newResponse = newResponseApdu.getBytes();
            byte[] combined = new byte[oldData.length + newResponse.length];
            System.arraycopy(oldData, 0, combined, 0, oldData.length);
            System.arraycopy(newResponse, 0, combined, oldData.length, newResponse.length);
            responseApdu = new ResponseAPDU(combined);
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReadProgress(FileType fileType, int offset, int estimatedMaxOffset) {
        if (offset > estimatedMaxOffset) {
            estimatedMaxOffset = offset;
        }
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifyReadProgress(fileType, offset, estimatedMaxOffset);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifyReadProgress():" + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySigningBegin(FileType keyType) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifySigningBegin(keyType);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifySigningBegin():" + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySigningEnd(FileType keyType) {
        List<BeIDCardListener> list = this.cardListeners;
        synchronized (list) {
            for (BeIDCardListener listener : this.cardListeners) {
                try {
                    listener.notifySigningEnd(keyType);
                }
                catch (Exception ex) {
                    this.logger.debug("Exception Thrown In BeIDCardListener.notifySigningBegin():" + ex.getMessage());
                }
            }
        }
    }

    private void verifyPin(PINPurpose purpose, String applicationName) throws IOException, CardException, InterruptedException, UserCancelledException {
        ResponseAPDU responseApdu;
        int retriesLeft = -1;
        do {
            if (36864 == (responseApdu = this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_DIRECT) ? this.verifyPINViaCCIDDirect(retriesLeft, purpose, applicationName) : (this.getCCID().hasFeature(CCID.FEATURE.VERIFY_PIN_START) ? this.verifyPINViaCCIDStartFinish(retriesLeft, purpose, applicationName) : this.verifyPINViaUI(retriesLeft, purpose, applicationName))).getSW()) continue;
            this.logger.debug("VERIFY_PIN error");
            this.logger.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
            if (27011 == responseApdu.getSW()) {
                this.getUI().advisePINBlocked();
                throw new ResponseAPDUException("eID card blocked!", responseApdu);
            }
            if (99 != responseApdu.getSW1()) {
                this.logger.debug("PIN verification error.");
                throw new ResponseAPDUException("PIN Verification Error", responseApdu);
            }
            retriesLeft = responseApdu.getSW2() & 0xF;
            this.logger.debug("retries left: " + retriesLeft);
        } while (36864 != responseApdu.getSW());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPINViaCCIDDirect(int retriesLeft, PINPurpose purpose, String applicationName) throws IOException, CardException {
        byte[] result;
        this.logger.debug("direct PIN verification...");
        this.getUI().advisePINPadPINEntry(retriesLeft, purpose, applicationName);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_DIRECT, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PIN));
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        if (25601 == responseApdu.getSW()) {
            this.logger.debug("canceled by user");
            SecurityException securityException = new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
            throw securityException;
        }
        if (25600 == responseApdu.getSW()) {
            this.logger.debug("PIN pad timeout");
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPINViaCCIDStartFinish(int retriesLeft, PINPurpose purpose, String applicationName) throws IOException, CardException, InterruptedException {
        this.logger.debug("CCID verify PIN start/end sequence...");
        this.getUI().advisePINPadPINEntry(retriesLeft, purpose, applicationName);
        try {
            this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_START, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PIN));
            this.getCCID().waitForOK();
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        return new ResponseAPDU(this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_FINISH));
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        boolean win = osName.contains("Windows");
        return win;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU verifyPINViaUI(int retriesLeft, PINPurpose purpose, String applicationName) throws CardException, UserCancelledException {
        boolean windows = this.isWindows();
        if (windows) {
            this.endExclusive();
        }
        char[] pin = this.getUI().obtainPIN(retriesLeft, purpose, applicationName);
        if (windows) {
            this.beginExclusive();
        }
        byte[] verifyData = new byte[]{(byte)(0x20 | pin.length), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < pin.length; idx += 2) {
            byte value;
            char digit1 = pin[idx];
            int digit2 = idx + 1 < pin.length ? pin[idx + 1] : 63;
            verifyData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(pin, '\u0000');
        this.logger.debug("verifying PIN...");
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.VERIFY_PIN, verifyData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(verifyData, (byte)0);
        }
    }

    private ResponseAPDU changePINViaCCIDDirect(int retriesLeft) throws IOException, CardException {
        byte[] result;
        this.logger.debug("direct PIN modification...");
        this.getUI().advisePINPadChangePIN(retriesLeft);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_DIRECT, this.getCCID().createPINModificationDataStructure(this.getLocale(), CCID.INS.MODIFY_PIN));
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        switch (responseApdu.getSW()) {
            case 25602: {
                this.logger.debug("PINs differ");
                break;
            }
            case 25601: {
                this.logger.debug("canceled by user");
                SecurityException securityException = new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
                throw securityException;
            }
            case 25600: {
                this.logger.debug("PIN pad timeout");
                break;
            }
        }
        return responseApdu;
    }

    private ResponseAPDU changePINViaCCIDStartFinish(int retriesLeft) throws IOException, CardException, InterruptedException {
        this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_START, this.getCCID().createPINModificationDataStructure(this.getLocale(), CCID.INS.MODIFY_PIN));
        try {
            this.logger.debug("enter old PIN...");
            this.getUI().advisePINPadOldPINEntry(retriesLeft);
            this.getCCID().waitForOK();
            this.getUI().advisePINPadOperationEnd();
            this.logger.debug("enter new PIN...");
            this.getUI().advisePINPadNewPINEntry(retriesLeft);
            this.getCCID().waitForOK();
            this.getUI().advisePINPadOperationEnd();
            this.logger.debug("enter new PIN again...");
            this.getUI().advisePINPadNewPINEntryAgain(retriesLeft);
            this.getCCID().waitForOK();
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        return new ResponseAPDU(this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.MODIFY_PIN_FINISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU changePINViaUI(int retriesLeft) throws CardException {
        byte value;
        int digit2;
        char digit1;
        int idx;
        char[][] pins = this.getUI().obtainOldAndNewPIN(retriesLeft);
        char[] oldPin = pins[0];
        char[] newPin = pins[1];
        byte[] changePinData = new byte[]{(byte)(0x20 | oldPin.length), -1, -1, -1, -1, -1, -1, -1, (byte)(0x20 | newPin.length), -1, -1, -1, -1, -1, -1, -1};
        for (idx = 0; idx < oldPin.length; idx += 2) {
            digit1 = oldPin[idx];
            digit2 = idx + 1 < oldPin.length ? oldPin[idx + 1] : 63;
            changePinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(oldPin, '\u0000');
        for (idx = 0; idx < newPin.length; idx += 2) {
            digit1 = newPin[idx];
            digit2 = idx + 1 < newPin.length ? newPin[idx + 1] : 63;
            changePinData[idx / 2 + 1 + 8] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(newPin, '\u0000');
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.CHANGE_PIN, changePinData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(changePinData, (byte)0);
        }
    }

    private ResponseAPDU unblockPINViaCCIDVerifyPINDirectOfPUK(int retriesLeft) throws IOException, CardException {
        byte[] result;
        this.logger.debug("direct PUK verification...");
        this.getUI().advisePINPadPUKEntry(retriesLeft);
        try {
            result = this.transmitCCIDControl(this.getCCID().usesPPDU(), CCID.FEATURE.VERIFY_PIN_DIRECT, this.getCCID().createPINVerificationDataStructure(this.getLocale(), CCID.INS.VERIFY_PUK));
        }
        finally {
            this.getUI().advisePINPadOperationEnd();
        }
        ResponseAPDU responseApdu = new ResponseAPDU(result);
        if (25601 == responseApdu.getSW()) {
            this.logger.debug("canceled by user");
            SecurityException securityException = new SecurityException("canceled by user", new ResponseAPDUException(responseApdu));
            throw securityException;
        }
        if (25600 == responseApdu.getSW()) {
            this.logger.debug("PIN pad timeout");
        }
        return responseApdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU unblockPINViaUI(int retriesLeft) throws CardException {
        char[][] puks = this.getUI().obtainPUKCodes(retriesLeft);
        char[] puk1 = puks[0];
        char[] puk2 = puks[1];
        char[] fullPuk = new char[puk1.length + puk2.length];
        System.arraycopy(puk2, 0, fullPuk, 0, puk2.length);
        Arrays.fill(puk2, '\u0000');
        System.arraycopy(puk1, 0, fullPuk, puk2.length, puk1.length);
        Arrays.fill(puk1, '\u0000');
        byte[] unblockPinData = new byte[]{(byte)(0x20 | (byte)(puk1.length + puk2.length)), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < fullPuk.length; idx += 2) {
            byte value;
            char digit1 = fullPuk[idx];
            char digit2 = fullPuk[idx + 1];
            unblockPinData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(fullPuk, '\u0000');
        try {
            ResponseAPDU responseAPDU = this.transmitCommand(BeIDCommandAPDU.RESET_PIN, unblockPinData);
            return responseAPDU;
        }
        finally {
            Arrays.fill(unblockPinData, (byte)0);
        }
    }

    private CCID getCCID() {
        if (this.ccid == null) {
            this.ccid = new CCID(this.card, this.cardTerminal, this.logger);
        }
        return this.ccid;
    }

    private BeIDCardUI getUI() {
        if (this.ui == null) {
            if (GraphicsEnvironment.isHeadless()) {
                this.logger.error(UI_DEFAULT_REQUIRES_HEAD);
                throw new UnsupportedOperationException(UI_DEFAULT_REQUIRES_HEAD);
            }
            try {
                ClassLoader classLoader = BeIDCard.class.getClassLoader();
                Class<?> uiClass = classLoader.loadClass(DEFAULT_UI_IMPLEMENTATION);
                this.ui = (BeIDCardUI)uiClass.newInstance();
                if (this.locale != null) {
                    this.ui.setLocale(this.locale);
                }
            }
            catch (Exception e) {
                this.logger.error(UI_MISSING_LOG_MESSAGE);
                throw new UnsupportedOperationException(UI_MISSING_LOG_MESSAGE, e);
            }
        }
        return this.ui;
    }

    public CardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    public void setCardTerminal(CardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
    }

    private byte[] toDERSignature(byte[] rawSign) {
        int len = rawSign.length / 2;
        byte[] rawR = new byte[len];
        byte[] rawS = new byte[len];
        System.arraycopy(rawSign, 0, rawR, 0, len);
        System.arraycopy(rawSign, len, rawS, 0, len);
        BigInteger bigIntR = new BigInteger(1, rawR);
        BigInteger bigIntS = new BigInteger(1, rawS);
        byte[] r = bigIntR.toByteArray();
        byte[] s = bigIntS.toByteArray();
        byte[] der = new byte[r.length + s.length + 6];
        der[0] = 48;
        der[1] = (byte)(r.length + s.length + 4);
        der[2] = 2;
        der[3] = (byte)r.length;
        System.arraycopy(r, 0, der, 4, r.length);
        der[4 + r.length] = 2;
        der[5 + r.length] = (byte)s.length;
        System.arraycopy(s, 0, der, 6 + r.length, s.length);
        return der;
    }

    private static enum BeIDCommandAPDU {
        SELECT_APPLET(0, 164, 4, 12),
        SELECT_FILE(0, 164, 8, 12),
        READ_BINARY(0, 176),
        VERIFY_PIN(0, 32, 0, 1),
        CHANGE_PIN(0, 36, 0, 1),
        SELECT_ALGORITHM_AND_PRIVATE_KEY(0, 34, 65, 182),
        COMPUTE_DIGITAL_SIGNATURE(0, 42, 158, 154),
        RESET_PIN(0, 44, 0, 1),
        GET_CHALLENGE(0, 132, 0, 0),
        GET_CARD_DATA(128, 228, 0, 0),
        GET_CARD_DATA_1_8(128, 228, 0, 1),
        PPDU(255, 194, 1),
        INTERNAL_AUTHENTICATE(0, 136, 2, 129);

        private final int cla;
        private final int ins;
        private final int p1;
        private final int p2;

        private BeIDCommandAPDU(int cla, int ins, int p1, int p2) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = p1;
            this.p2 = p2;
        }

        private BeIDCommandAPDU(int cla, int ins, int p1) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = p1;
            this.p2 = -1;
        }

        private BeIDCommandAPDU(int cla, int ins) {
            this.cla = cla;
            this.ins = ins;
            this.p1 = -1;
            this.p2 = -1;
        }

        public int getCla() {
            return this.cla;
        }

        public int getIns() {
            return this.ins;
        }

        public int getP1() {
            return this.p1;
        }

        public int getP2() {
            return this.p2;
        }
    }
}

