/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.jaxb;

import javax.activation.DataHandler;
import javax.xml.bind.annotation.*;

/**
 * @author EHP
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "AttachmentRoot", namespace = "urn:be:ehealth:technicalconnector:jaxb")
@XmlType(name = "AttachmentRoot", propOrder = {"contentAsRef", "contentInline"})
public class AttachmentRoot {

    @XmlElement(name = "ContentAsRef", type = String.class)
    @XmlAttachmentRef
    protected DataHandler contentAsRef;

    @XmlElement(name = "ContentInline")
    protected byte[] contentInline;


    public DataHandler getContentAsRef() {
        return contentAsRef;
    }


    public void setContentAsRef(DataHandler contentAsRef) {
        this.contentAsRef = contentAsRef;
    }


    public byte[] getContentInline() {
        return contentInline;
    }


    public void setContentInline(byte[] contentInline) {
        this.contentInline = contentInline;
    }


}
