/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CmsEncrypter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmsEncrypter.class);
    private final ASN1ObjectIdentifier privateKeyContentEncryptionAlgorithm;
    private final ASN1ObjectIdentifier secretKeyContentEncryptionAlgorithm;

    CmsEncrypter(EncryptionPolicy publicKeyEncryptionPolicy, EncryptionPolicy secretKeyEncryptionPolicy) {
        this.privateKeyContentEncryptionAlgorithm = new ASN1ObjectIdentifier(publicKeyEncryptionPolicy.getContentEncryptionAlgorithmOID());
        this.secretKeyContentEncryptionAlgorithm = new ASN1ObjectIdentifier(secretKeyEncryptionPolicy.getContentEncryptionAlgorithmOID());
    }

    byte[] encryptData(byte[] dataToBeEncrypted, EncryptionCredential ... encryptionKeys) throws IOException, CMSException, CertificateEncodingException {
        Preconditions.checkNotNull(dataToBeEncrypted, "The DataToBeEncrypted may not be null.");
        if (encryptionKeys == null || encryptionKeys.length == 0) {
            throw new IllegalArgumentException("At least one addressee (known or unknown) must be given.)");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encrypting data " + dataToBeEncrypted.length + " bytes..");
        }
        CMSEnvelopedDataGenerator envelopedDataGen = new CMSEnvelopedDataGenerator();
        boolean secretKeyPresent = this.addRecipientInfo(encryptionKeys, (CMSEnvelopedGenerator)envelopedDataGen);
        return envelopedDataGen.generate((CMSTypedData)new CMSProcessableByteArray(dataToBeEncrypted), this.createOutputEncryptor(secretKeyPresent)).getEncoded();
    }

    OutputStream openDataToBeEncryptedStream(OutputStream encryptedDataStream, EncryptionCredential ... encryptionKeys) throws CertificateEncodingException, CMSException, IOException {
        Preconditions.checkNotNull(encryptedDataStream, "Given encryptedDataStream must not be null.");
        if (encryptionKeys == null || encryptionKeys.length == 0) {
            throw new IllegalArgumentException("At least one addressee (known or unknown) must be given.)");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Encrypting data stream ..");
        }
        CMSEnvelopedDataStreamGenerator envelopedDataGen = new CMSEnvelopedDataStreamGenerator();
        boolean secretKeyPresent = this.addRecipientInfo(encryptionKeys, (CMSEnvelopedGenerator)envelopedDataGen);
        return envelopedDataGen.open(encryptedDataStream, this.createOutputEncryptor(secretKeyPresent));
    }

    private boolean addRecipientInfo(EncryptionCredential[] encryptionKeys, CMSEnvelopedGenerator envelopedDataGen) throws CertificateEncodingException {
        boolean secretKeyPresent = false;
        ArrayList<String> knownRecipients = new ArrayList<String>();
        ArrayList<String> unknownRecipients = new ArrayList<String>();
        for (EncryptionCredential key : encryptionKeys) {
            if (key.getCertificate() != null) {
                knownRecipients.add(key.getKeyId());
                envelopedDataGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(key.getCertificate()));
                continue;
            }
            if (key.getPublicKey() != null) {
                knownRecipients.add(key.getKeyId());
                envelopedDataGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(Base64.decode((String)key.getKeyId()), key.getPublicKey()));
                continue;
            }
            if (key.getSymKek() != null) {
                secretKeyPresent = true;
                unknownRecipients.add(key.getKeyId());
                envelopedDataGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKEKRecipientInfoGenerator(Base64.decode((String)key.getKeyId()), key.getSymKek()));
                continue;
            }
            LOGGER.warn("Unsupported EncryptionCredential [keyId=" + key.getKeyId() + "]");
        }
        LOGGER.info("Message recipients: Known=" + knownRecipients + ", Unknown=" + unknownRecipients);
        return secretKeyPresent;
    }

    private OutputEncryptor createOutputEncryptor(boolean secretKeyPresent) throws CMSException {
        return secretKeyPresent ? new JceCMSContentEncryptorBuilder(this.secretKeyContentEncryptionAlgorithm).build() : new JceCMSContentEncryptorBuilder(this.privateKeyContentEncryptionAlgorithm).build();
    }
}

