/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.services.validation.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.SilentInstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.schematron.exception.InitialisationException;
import be.fgov.ehealth.technicalconnector.services.schematron.SchematronValidationResult;
import be.fgov.ehealth.technicalconnector.services.schematron.SchematronValidator;
import be.fgov.ehealth.technicalconnector.services.validation.ProjectMessageValidator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectMessageValidatorImpl
implements ProjectMessageValidator,
ConfigurableImplementation {
    private static ConfigValidator config = ConfigFactory.getConfigValidator();
    private SchematronValidator validator;
    private Schematron schematron;
    private static Map<String, Schematron> schematrons = new HashMap<String, Schematron>();
    public static final String URI = "urn:be:fgov:ehealth:standards:validation:v1";
    public static final String PROP_SCHEMATRONS_XML = "be.fgov.ehealth.technicalconnector.services.validation.schematron";

    private static String getDefaultLocation() {
        String endpoint = config.getProperty(PROP_SCHEMATRONS_XML);
        if (StringUtils.isNotBlank((String)endpoint)) {
            return endpoint;
        }
        return "https://raw.githubusercontent.com/ehealthplatformstandards/schematrons/prod/overview.xml";
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        ProjectMessageValidatorImpl.contains(parameterMap, "schematronProject");
        String project = parameterMap.get("schematronProject").toString();
        ProjectMessageValidatorImpl.contains(schematrons, project);
        this.schematron = schematrons.get(project);
        ProjectMessageValidatorImpl.contains(parameterMap, "schematronValidator");
        this.validator = (SchematronValidator)parameterMap.get("schematronValidator");
    }

    private static void contains(Map<String, ?> parameterMap, String parameter) throws SilentInstantiationException {
        if (!parameterMap.containsKey(parameter)) {
            throw new SilentInstantiationException((Exception)new IllegalArgumentException("Unable to find required param [" + parameter + "]"));
        }
    }

    @Override
    public SchematronValidationResult validate(String inputLocation) throws TechnicalConnectorException, InitialisationException {
        return this.validate(ConnectorIOUtils.getResourceAsStream((String)inputLocation));
    }

    @Override
    public SchematronValidationResult validate(InputStream input) throws TechnicalConnectorException, InitialisationException {
        return this.validator.validate(input, this.schematron.getContentAsStream());
    }

    static {
        try {
            String schematronsLocation = ConfigFactory.getConfigValidator().getProperty(PROP_SCHEMATRONS_XML, ProjectMessageValidatorImpl.getDefaultLocation());
            Document doc = ConnectorXmlUtils.toDocument((byte[])ConnectorIOUtils.getResourceAsByteArray((String)(schematronsLocation + ".xml")));
            NodeList schematronList = doc.getElementsByTagNameNS(URI, "schematron");
            for (int i = 0; i < schematronList.getLength(); ++i) {
                Element schematron = (Element)schematronList.item(i);
                String path = StringUtils.trim((String)schematron.getElementsByTagNameNS(URI, "path").item(0).getTextContent());
                String project = StringUtils.trim((String)schematron.getElementsByTagNameNS(URI, "name").item(0).getTextContent());
                String hash = StringUtils.trim((String)schematron.getElementsByTagNameNS(URI, "hash").item(0).getTextContent());
                if (schematrons.containsKey(project) && schematrons.get(project).getHash().equals(hash)) continue;
                byte[] sch = ConnectorIOUtils.getResourceAsByteArray((String)path);
                schematrons.put(project, new Schematron(path, hash, sch));
            }
        }
        catch (TechnicalConnectorException e) {
            throw new IllegalArgumentException("Unable to load schematron directory", e);
        }
    }

    private static class Schematron {
        private byte[] content;
        private String hash;
        private String name;

        public Schematron(String name, String hash, byte[] content) {
            this.content = content;
            this.hash = hash;
            this.name = name;
        }

        public String getHash() {
            return this.hash;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getContent() {
            return ArrayUtils.clone((byte[])this.content);
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.getContent());
        }
    }
}

