package be.fgov.ehealth.technicalconnector.tests.server.callback;

import org.apache.commons.lang.StringUtils;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class ErrorExpectationCallback implements ExpectationCallback {

    @Override
    public HttpResponse handle(HttpRequest httpRequest) {
            Integer errorCode = Integer.valueOf(StringUtils.substringAfterLast(httpRequest.getPath().getValue(), "/"));
            return HttpResponse.response()
                        .withStatusCode(errorCode)
                        .withHeader("Content-Type", "text/html");



    }
}
