package be.fgov.ehealth.technicalconnector.services.daas;

import be.fgov.ehealth.technicalconnector.services.ServiceFactory;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.junit.*;
import org.junit.rules.ExpectedException;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static be.fgov.ehealth.technicalconnector.services.daas.AttributeValue.ValueType.ACTOR;
import static be.fgov.ehealth.technicalconnector.services.daas.AttributeValue.ValueType.STRING;
import static be.fgov.ehealth.technicalconnector.services.daas.DaasAssertionUtils.assertAttributeValue;

/**
 * @author EHP
 */
public class DataAttributeServiceIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession()
            .baseOn("/be.ehealth.technicalconnector.daas.test.properties")
            .build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void before() {
        LoggingUtils.bootstrap();
    }

    @Test
    public void invokeSuccess() throws Exception {

        Map<String, List<String>> attr = new HashMap<String, List<String>>();
        String ssin = rule.getTestProperty("test.daas.success.ssin");
        attr.put("urn:be:fgov:person:ssin", Arrays.asList(ssin));
        attr.put("urn:be:fgov:person:ssin:ehealth:1.0:listofpreventionservices", null);
        attr.put("urn:be:fgov:ehealth:1.0:service-name", Arrays.asList(rule.getTestProperty("test.daas.success.service-name")));

        Map<String, List<AttributeValue>> result = ServiceFactory.getDataAttributeService().invoke(attr);

        Assert.assertEquals(3, result.size());
        assertAttributeValue(result, "urn:be:fgov:person:ssin", 1, STRING);
        assertAttributeValue(result, "urn:be:fgov:ehealth:1.0:service-name", 1, STRING);
        assertAttributeValue(result, "urn:be:fgov:person:ssin:ehealth:1.0:listofpreventionservices", 3, ACTOR);

    }

    @Test
    public void invalidSSIN() throws Exception {

        expectedException.expect(DaasServiceException.class);
        expectedException.expectMessage("Invalid input parameter. Reason: Attribute urn:be:fgov:person:ssin could not be resolved: Invalid input");

        Map<String, List<String>> attr = new HashMap<String, List<String>>();
        attr.put("urn:be:fgov:person:ssin", Arrays.asList("1234567"));
        attr.put("urn:be:fgov:person:ssin:ehealth:1.0:listofpreventionservices", null);
        attr.put("urn:be:fgov:ehealth:1.0:service-name", Arrays.asList("urn:be:fgov:ehealth:admin:simplification:backtowork"));

        ServiceFactory.getDataAttributeService().invoke(attr);

    }
}