/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.dialogs;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.OutOfCardsException;
import be.fedict.commons.eid.client.impl.LocaleManager;
import be.fedict.commons.eid.client.spi.BeIDCardsUI;
import be.fedict.commons.eid.dialogs.BeIDSelector;
import be.fedict.commons.eid.dialogs.Messages;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefaultBeIDCardsUI
implements BeIDCardsUI {
    private Component parentComponent;
    private Messages messages;
    private JFrame adviseFrame;
    private BeIDSelector selectionDialog;
    private Locale locale;

    public DefaultBeIDCardsUI() {
        this(null);
    }

    public DefaultBeIDCardsUI(Component parentComponent) {
        this(parentComponent, null);
    }

    public DefaultBeIDCardsUI(Component parentComponent, Messages messages) {
        this.parentComponent = parentComponent;
        this.messages = messages;
        if (GraphicsEnvironment.isHeadless()) {
            throw new UnsupportedOperationException("DefaultBeIDCardsUI is a GUI and cannot run in a headless environment");
        }
        if (messages != null) {
            this.messages = messages;
            this.setLocale(messages.getLocale());
        } else {
            this.messages = Messages.getInstance(this.getLocale());
        }
    }

    public void adviseCardTerminalRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.CONNECT_READER), this.messages.getMessage(Messages.MESSAGE_ID.CONNECT_READER));
    }

    public void adviseBeIDCardRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.INSERT_CARD_QUESTION), this.messages.getMessage(Messages.MESSAGE_ID.INSERT_CARD_QUESTION));
    }

    public void adviseBeIDCardRemovalRequired() {
        this.showAdvise(this.messages.getMessage(Messages.MESSAGE_ID.REMOVE_CARD), this.messages.getMessage(Messages.MESSAGE_ID.REMOVE_CARD));
    }

    public BeIDCard selectBeIDCard(Collection<BeIDCard> availableCards) throws CancelledException, OutOfCardsException {
        try {
            this.selectionDialog = new BeIDSelector(this.parentComponent, "Select eID card", availableCards);
            BeIDCard beIDCard = this.selectionDialog.choose();
            return beIDCard;
        }
        finally {
            this.selectionDialog = null;
        }
    }

    public void adviseEnd() {
        if (null != this.adviseFrame) {
            this.adviseFrame.dispose();
            this.adviseFrame = null;
        }
    }

    private void showAdvise(String title, String message) {
        if (null != this.adviseFrame) {
            this.adviseEnd();
        }
        this.adviseFrame = new JFrame(title);
        this.adviseFrame.setAlwaysOnTop(true);
        this.adviseFrame.setResizable(false);
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 30, 10, 30);
            }
        };
        BoxLayout boxLayout = new BoxLayout(panel, 3);
        panel.setLayout(boxLayout);
        panel.add(new JLabel(message));
        this.adviseFrame.getContentPane().add(panel);
        this.adviseFrame.pack();
        if (this.parentComponent != null) {
            this.adviseFrame.setLocationRelativeTo(this.parentComponent);
        } else {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            int screenWidth = displayMode.getWidth();
            int screenHeight = displayMode.getHeight();
            int dialogWidth = this.adviseFrame.getWidth();
            int dialogHeight = this.adviseFrame.getHeight();
            this.adviseFrame.setLocation((screenWidth - dialogWidth) / 2, (screenHeight - dialogHeight) / 2);
        }
        this.adviseFrame.setVisible(true);
    }

    public void eIDCardInsertedDuringSelection(BeIDCard card) {
        if (this.selectionDialog != null) {
            this.selectionDialog.addEIDCard(card);
        }
    }

    public void eIDCardRemovedDuringSelection(BeIDCard card) {
        if (this.selectionDialog != null) {
            this.selectionDialog.removeEIDCard(card);
        }
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        this.messages = Messages.getInstance(newLocale);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return LocaleManager.getLocale();
    }
}

