package be.fgov.ehealth.technicalconnector.tests.junit.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;

/**
 *
 * @author EHP
 */
public class DateTimeMatcher extends TypeSafeMatcher<DateTime> {

    private DateTime expected;

    private DateTimeMatcher(DateTime expected) {
        this.expected = expected;
    }

    @Override
    protected boolean matchesSafely(DateTime item) {
        return expected.isEqual(item);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("isEqual to")
                   .appendValue(expected);
    }

    public static Matcher<DateTime> isEqual(DateTime dateTime) {
        return new DateTimeMatcher(dateTime);
    }

}