/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.impl.AttachmentMarshallerImpl;
import be.ehealth.technicalconnector.utils.impl.AttachmentUnmarshallerImpl;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MarshallerHelper<X, Y> {
    private static final Logger LOG = LoggerFactory.getLogger(MarshallerHelper.class);
    public static final int DEFAULT_XOP_THRESHOLD = 10;
    private AttachmentMarshallerImpl attachmentMarshaller;
    private Map<String, AttachmentPart> attachmentParts = new HashMap<String, AttachmentPart>();
    private Class<Y> marshallClass;
    private Class<X> unmarshallClass;
    private boolean format;
    private boolean xop;
    private int threshold;

    public MarshallerHelper(Class<X> unmarshallClass, Class<Y> marshallClass) {
        this.createMarshaller(unmarshallClass, marshallClass, false, false, 10);
    }

    public MarshallerHelper(Class<X> unmarshallClass, Class<Y> marshallClass, boolean format) {
        this.createMarshaller(unmarshallClass, marshallClass, format, false, 10);
    }

    public MarshallerHelper(Class<X> unmarshallClass, Class<Y> marshallClass, boolean format, boolean xop) {
        this.createMarshaller(unmarshallClass, marshallClass, format, xop, 10);
    }

    public MarshallerHelper(Class<X> unmarshallClass, Class<Y> marshallClass, boolean format, boolean xop, int threshold) {
        this.createMarshaller(unmarshallClass, marshallClass, format, xop, threshold);
    }

    public void addAttachmentPart(String id, AttachmentPart attachmentPart) {
        this.attachmentParts.put(id, attachmentPart);
    }

    public void clearAttachmentPartMap() {
        this.attachmentParts.clear();
    }

    private void createMarshaller(Class<X> inUnmarshallClass, Class<Y> inMarshallClass, Boolean format, Boolean xop, int threshold) {
        this.format = format;
        this.unmarshallClass = inUnmarshallClass;
        this.marshallClass = inMarshallClass;
        this.xop = xop;
        this.threshold = threshold;
    }

    public Map<String, DataHandler> getDataHandlersMap() {
        return this.attachmentMarshaller.getDataHandlerMap();
    }

    public Document toDocument(Y data) {
        try {
            Document doc = ConnectorXmlUtils.getDocumentBuilder().newDocument();
            if (data.getClass().isAnnotationPresent(XmlRootElement.class)) {
                this.getMarshaller().marshal(data, (Node)doc);
            } else {
                JAXBElement jaxbElement = new JAXBElement(MarshallerHelper.translate(data.getClass()), this.marshallClass, data);
                this.getMarshaller().marshal((Object)jaxbElement, (Node)doc);
            }
            return doc;
        }
        catch (JAXBException e) {
            throw MarshallerHelper.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X toObject(byte[] data) {
        X x;
        ByteArrayInputStream boas = null;
        try {
            boas = new ByteArrayInputStream(data);
            x = this.toObject(boas);
        }
        catch (Throwable throwable) {
            ConnectorIOUtils.closeQuietly(boas);
            throw throwable;
        }
        ConnectorIOUtils.closeQuietly((Object)boas);
        return x;
    }

    public X toObject(InputStream inputStream) {
        try {
            JAXBElement root = this.getUnMarshaller().unmarshal((Source)new StreamSource(inputStream), this.unmarshallClass);
            Object object = root.getValue();
            return (X)object;
        }
        catch (JAXBException e) {
            throw MarshallerHelper.handleException(e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)inputStream);
        }
    }

    public X toObject(Node source) {
        try {
            return (X)this.getUnMarshaller().unmarshal(source);
        }
        catch (JAXBException e) {
            try {
                LOG.debug("Unable to unmarshall class from source.", (Throwable)e);
                return (X)this.getUnMarshaller().unmarshal(source, this.unmarshallClass).getValue();
            }
            catch (JAXBException e1) {
                e1.setLinkedException((Throwable)e);
                throw MarshallerHelper.handleException(e1);
            }
        }
    }

    public X toObject(String data) {
        try {
            return this.toObject(ConnectorIOUtils.toBytes(data, Charset.UTF_8));
        }
        catch (TechnicalConnectorException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public X toObjectNoRootElementRequired(byte[] data) {
        return this.toObject(data);
    }

    public String toString(Y data) {
        StringWriter writer = new StringWriter();
        try {
            if (data.getClass().isAnnotationPresent(XmlRootElement.class) || data instanceof JAXBElement) {
                this.getMarshaller().marshal(data, (Writer)writer);
            } else {
                JAXBElement jaxbElement = new JAXBElement(MarshallerHelper.translate(data.getClass()), this.marshallClass, data);
                this.getMarshaller().marshal((Object)jaxbElement, (Writer)writer);
            }
        }
        catch (JAXBException e) {
            throw MarshallerHelper.handleException(e);
        }
        return writer.toString();
    }

    private static QName translate(Class<?> clazz) {
        for (Annotation annotation : clazz.getPackage().getAnnotations()) {
            if (!(annotation instanceof XmlSchema)) continue;
            XmlSchema schema = (XmlSchema)annotation;
            return new QName(schema.namespace(), clazz.getSimpleName());
        }
        LOG.debug("Unable to determine QName for class:{} using package as namespace.", clazz);
        return new QName(clazz.getPackage().getName(), clazz.getSimpleName());
    }

    @Deprecated
    public String toStringNoRootElementRequired(Y data) {
        return this.toString(data);
    }

    public byte[] toXMLByteArray(Y data) {
        ByteArrayOutputStream bos = null;
        try {
            Object jaxbElement;
            bos = new ByteArrayOutputStream();
            if (data.getClass().isAnnotationPresent(XmlRootElement.class)) {
                this.getMarshaller().marshal(data, (OutputStream)bos);
            } else {
                jaxbElement = new JAXBElement(MarshallerHelper.translate(data.getClass()), this.marshallClass, data);
                this.getMarshaller().marshal(jaxbElement, (OutputStream)bos);
            }
            jaxbElement = bos.toByteArray();
            return jaxbElement;
        }
        catch (JAXBException e) {
            throw MarshallerHelper.handleException(e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)bos);
        }
    }

    @Deprecated
    public byte[] toXMLByteArrayNoRootElementRequired(Y data) {
        return this.toXMLByteArray(data);
    }

    @Deprecated
    public byte[] toXMLByteArrayNoRootElementRequired(Y data, QName rootTag) {
        return this.toXMLByteArrayNoRootElementRequired(data);
    }

    private static IllegalArgumentException handleException(JAXBException e) {
        throw new IllegalArgumentException("Unable to (un)marchall class. Reason: " + (Object)((Object)e), e);
    }

    private Marshaller getMarshaller() throws JAXBException {
        this.attachmentMarshaller = new AttachmentMarshallerImpl(this.xop, this.threshold);
        Marshaller marshaller = JaxbContextFactory.getJaxbContextForClass(this.marshallClass).createMarshaller();
        marshaller.setAttachmentMarshaller((AttachmentMarshaller)this.attachmentMarshaller);
        marshaller.setProperty("jaxb.encoding", (Object)Charset.UTF_8.getName());
        marshaller.setProperty("jaxb.formatted.output", (Object)this.format);
        return marshaller;
    }

    private Unmarshaller getUnMarshaller() throws JAXBException {
        AttachmentUnmarshallerImpl attachmentUnmarshaller = new AttachmentUnmarshallerImpl(true);
        attachmentUnmarshaller.getAttachmentPartMap().putAll(this.attachmentParts);
        Unmarshaller unmarshaller = JaxbContextFactory.getJaxbContextForClass(this.unmarshallClass).createUnmarshaller();
        unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)attachmentUnmarshaller);
        return unmarshaller;
    }
}

