/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;


/**
 * TODO: Description of the class.
 * 
 * @author eh053
 * 
 * @since
 * 
 */
@RunWith(Parameterized.class)
public class SecureStringTest {

    @Parameters(name = "{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList(new Object[][]{
            {
                ""
            }, {
                "test"
            }, {
                "µ"
            }, {
                "الصحة الإلكترونية"
            }, {
                "Jag hälsar Dig"
            }, {
                "здравоохранение"
            }
        });
    }

    private String value;


    public SecureStringTest(String value) {
        this.value = value;
    }

    @Test
    public void value() throws Exception {
        SecureString string = new SecureString(getValue());
        Assert.assertArrayEquals(getValue(), string.getValue());
    }

    @Test
    public void append() throws Exception {
        SecureString string = new SecureString(getValue());
        string.append(getValue());
        Assert.assertArrayEquals(ArrayUtils.addAll(getValue(), getValue()), string.getValue());
    }

    @Test(expected = IllegalArgumentException.class)
    public void initWithNull() throws Exception {
        new SecureString(null);
    }

    @Test(expected = IllegalArgumentException.class)
    public void appendWithNull() throws Exception {
        new SecureString("".toCharArray()).append(null);
    }

    private char[] getValue() {
        if (value == null) {
            return null;
        }
        return value.toCharArray();
    }

}
