/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleEhealthTime
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleEhealthTime.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        HttpURLConnection conn = null;
        try {
            URL url = new URL("http://services.ehealth.fgov.be");
            conn = (HttpURLConnection)url.openConnection();
            long requestTime = new Date().getTime();
            conn.setRequestMethod("GET");
            Date eHealthTime = FORMAT.parse(conn.getHeaderField("Date"));
            long diffInMillies = eHealthTime.getTime() - requestTime;
            long diff = TimeUnit.SECONDS.convert(Math.abs(diffInMillies), TimeUnit.MILLISECONDS);
            LOG.debug("eHealth time           : " + FORMAT.format(eHealthTime));
            LOG.debug("Local time             : " + FORMAT.format(requestTime));
            LOG.debug("diff with ehealth time : " + (0L > diff ? "-" : "") + diff + " seconds.");
        }
        catch (Exception e) {
            try {
                LOG.error("Unable to calculate ehealth time", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(conn);
                throw throwable;
            }
            ConnectorIOUtils.closeQuietly((Object)conn);
        }
        ConnectorIOUtils.closeQuietly((Object)conn);
    }

    @Override
    public void unload() throws TechnicalConnectorException {
    }
}

