/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.bootstrap.bcp.parser;

import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.bcp.protocol.v1.StatusType;
import be.fgov.ehealth.bcp.protocol.v2.Endpoint;
import be.fgov.ehealth.bcp.protocol.v2.Service;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.CacheInformation;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.domain.EndPointInformation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusPageParser {
    private static final Logger LOG = LoggerFactory.getLogger(StatusPageParser.class);
    private static final String URI_BCP_V2 = "urn:be:fgov:ehealth:bcp:protocol:v2";
    private static final String URI_BCP_V1 = "urn:be:fgov:ehealth:bcp:protocol:v1";

    private StatusPageParser() {
        throw new UnsupportedOperationException();
    }

    public static EndPointInformation parse(String xml) throws TechnicalConnectorException {
        EndPointInformation info = new EndPointInformation();
        ByteArrayInputStream is = new ByteArrayInputStream(ConnectorIOUtils.toBytes((String)xml, (Charset)Charset.UTF_8));
        try {
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = xmlif.createXMLStreamReader(is);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Service.class, be.fgov.ehealth.bcp.protocol.v1.Service.class});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            xmlr.nextTag();
            xmlr.require(1, null, "ServiceList");
            while (xmlr.getEventType() != 8) {
                if (xmlr.getEventType() == 1) {
                    Service service;
                    if (xmlr.getLocalName() == "Service" && xmlr.getNamespaceURI() == URI_BCP_V2) {
                        xmlr.require(1, URI_BCP_V2, "Service");
                        service = (Service)um.unmarshal(xmlr);
                        StatusPageParser.add(info, service);
                        continue;
                    }
                    if (xmlr.getLocalName() == "Service" && xmlr.getNamespaceURI() == URI_BCP_V1) {
                        xmlr.require(1, URI_BCP_V1, "Service");
                        service = (be.fgov.ehealth.bcp.protocol.v1.Service)um.unmarshal(xmlr);
                        StatusPageParser.add(info, (be.fgov.ehealth.bcp.protocol.v1.Service)service);
                        continue;
                    }
                    xmlr.next();
                    continue;
                }
                xmlr.next();
            }
            return info;
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_TECHNICAL, (Throwable)e, new Object[0]);
        }
    }

    private static void add(EndPointInformation info, be.fgov.ehealth.bcp.protocol.v1.Service service) {
        ArrayList<String> endpoints = new ArrayList<String>();
        String defaultEndpoint = null;
        String activeEndpoint = null;
        List endpointList = service.getEndpoints();
        for (be.fgov.ehealth.bcp.protocol.v1.Endpoint endpoint : endpointList) {
            endpoints.add(endpoint.getValue());
            if (endpoint.getStatus() == StatusType.ACTIVE) {
                activeEndpoint = endpoint.getValue();
            }
            if (endpoint.getOrder().toString(10) != "0") continue;
            defaultEndpoint = endpoint.getValue();
        }
        LOG.debug("Adding info to register {} activeURL {}, defaultURL {}, cache NO", new Object[]{service.getId(), activeEndpoint, defaultEndpoint});
        info.register(service.getId(), activeEndpoint, defaultEndpoint, endpoints, null);
    }

    private static void add(EndPointInformation info, Service service) {
        ArrayList<String> endpoints = new ArrayList<String>();
        String defaultEndpoint = null;
        String activeEndpoint = null;
        List endpointList = service.getEndpointList().getEndpoints();
        for (Endpoint endpoint : endpointList) {
            endpoints.add(endpoint.getValue());
            if (endpoint.getStatus() == be.fgov.ehealth.bcp.protocol.v2.StatusType.ACTIVE) {
                activeEndpoint = endpoint.getValue();
            }
            if (endpoint.getOrder().toString(10) != "0") continue;
            defaultEndpoint = endpoint.getValue();
        }
        CacheInformation.CacheType cacheType = CacheInformation.CacheType.valueOf((String)service.getCache().getStrategy());
        CacheInformation.ExpiryType expiryType = CacheInformation.ExpiryType.valueOf((String)service.getCache().getExpiry().getType().toUpperCase());
        CacheInformation.KeyTransformType keyTransformType = CacheInformation.KeyTransformType.valueOf((String)service.getCache().getKey().getTranform().toUpperCase());
        String keyTranformLocation = null;
        if (service.getCache().getKey().isInline()) {
            try {
                File file = File.createTempFile(service.getId().replaceAll(":", "_"), ".xslt");
                file.deleteOnExit();
                FileWriter fw = new FileWriter(file);
                IOUtils.write((String)service.getCache().getKey().getValue(), (Writer)fw);
                fw.flush();
                fw.close();
                keyTranformLocation = file.getAbsolutePath();
            }
            catch (IOException e) {
                LOG.debug("Unable to create inline XSLT file.", (Throwable)e);
            }
        } else {
            keyTranformLocation = service.getCache().getKey().getValue();
        }
        Duration duration = null;
        javax.xml.datatype.Duration xmlDuration = service.getCache().getExpiry().getDuration();
        if (xmlDuration != null) {
            duration = new Duration(xmlDuration.getTimeInMillis(Calendar.getInstance()));
        }
        CacheInformation cacheInformation = new CacheInformation(service.getId(), cacheType, keyTransformType, keyTranformLocation, expiryType, duration);
        LOG.debug("Adding info to register {} with cache{}", (Object)service.getId(), (Object)cacheInformation);
        info.register(service.getId(), activeEndpoint, defaultEndpoint, endpoints, cacheInformation);
    }
}

