/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.session.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.session.SessionItem;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemImpl
implements SessionItem {
    private static final Logger LOG = LoggerFactory.getLogger(SessionItemImpl.class);
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_USER_FIRSTNAME = "";
    private static final String PROP_USER_LASTNAME = "";
    private SAMLToken token;
    private Credential hokCredential;
    private Crypto cryptoSystem;
    private Crypto cryptoPersonal;
    private Map<String, PrivateKey> hokPrivateKeys;
    private Credential encryptionCredential;
    private Credential headerCredential;
    private Map<String, PrivateKey> encryptionPrivateKeys;
    private ConfigValidator config;

    private void initIfNeeded() {
        if (this.config == null) {
            this.config = ConfigFactory.getConfigValidator(expectedProps);
        }
    }

    public SessionItemImpl() {
        this.initIfNeeded();
    }

    @Override
    public void setSAMLToken(SAMLToken token) {
        this.token = token;
    }

    @Override
    public final SAMLToken getSAMLToken() {
        return this.token;
    }

    @Override
    public final void setHolderOfKeyCredential(Credential hokCredential) {
        this.hokCredential = hokCredential;
    }

    @Override
    public final Credential getHolderOfKeyCredential() {
        return this.hokCredential;
    }

    @Override
    public final void setHolderOfKeyPrivateKeys(Map<String, PrivateKey> hokPrivateKeys) {
        this.hokPrivateKeys = hokPrivateKeys;
    }

    @Override
    public final Map<String, PrivateKey> getHolderOfKeyPrivateKeys() {
        return this.hokPrivateKeys;
    }

    @Override
    public final void setEncryptionCredential(Credential encryptionCredential) {
        this.encryptionCredential = encryptionCredential;
    }

    @Override
    public final Credential getEncryptionCredential() {
        if (this.encryptionCredential == null) {
            LOG.warn("Session Initialized without encryption: return null.");
        }
        return this.encryptionCredential;
    }

    @Override
    public final void setEncryptionPrivateKeys(Map<String, PrivateKey> encryptionPrivateKeys) {
        this.encryptionPrivateKeys = encryptionPrivateKeys;
    }

    @Override
    public final Map<String, PrivateKey> getEncryptionPrivateKeys() {
        if (this.encryptionPrivateKeys == null) {
            LOG.warn("Session Initialized without encryption: return null.");
        }
        return this.encryptionPrivateKeys;
    }

    @Override
    public Crypto getHolderOfKeyCrypto() throws TechnicalConnectorException {
        LOG.debug("Retrieving HOK Crypto... (for sealing and unsealing)");
        if (this.cryptoSystem == null) {
            LOG.debug("No HOK Crypto has been created. User has valid session, creating crypto...");
            this.cryptoSystem = CryptoFactory.getCrypto(this.getHolderOfKeyCredential(), this.getHolderOfKeyPrivateKeys());
            LOG.debug("HOK crypto created: " + this.cryptoSystem);
        }
        return this.cryptoSystem;
    }

    @Override
    public Crypto getEncryptionCrypto() throws TechnicalConnectorException {
        LOG.debug("Retrieving personal Crypto... (for sealing and unsealing)");
        if (this.cryptoPersonal == null) {
            LOG.debug("No personal Crypto has been created. User has valid session, creating crypto...");
            this.cryptoPersonal = CryptoFactory.getCrypto(this.getEncryptionCredential(), this.getEncryptionPrivateKeys());
            LOG.debug("System crypto created: " + this.cryptoPersonal);
        }
        return this.cryptoPersonal;
    }

    @Override
    public void setHeaderCredential(Credential headerCredential) throws TechnicalConnectorException {
        this.headerCredential = headerCredential;
    }

    @Override
    public Credential getHeaderCredential() throws TechnicalConnectorException {
        return this.headerCredential;
    }

    static {
        expectedProps.add("");
        expectedProps.add("");
    }
}

