/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.beid;

import be.ehealth.technicalconnector.beid.BeIDCardAdaptor;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fedict.commons.eid.client.BeIDCard;


/**
 * Dummy BEIFAdaptor
 * 
 * @author EHP
 * 
 */
public class DummyBeIDAdaptor implements BeIDCardAdaptor {

    /**
     * Name of the person to obtain the {@link BeIDCard}
     */
    public static final String LOCATION = "be.fgov.ehealth.technicalconnector.tests.beid.dummybeidadaptor.location";

    /**
     * @see be.ehealth.technicalconnector.beid.BeIDCardAdaptor#getBeIDCard()
     */
    @Override
    public BeIDCard getBeIDCard() throws TechnicalConnectorException {
        String cardname = ConfigFactory.getConfigValidator().getProperty(LOCATION, "/beid/Alice.xml");
        return new DummyBeIDCard(cardname);
    }

}
