/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.BeIDPinCodeException;
import be.ehealth.technicalconnector.exception.ResponseAPDUException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCSCUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PCSCUtils.class);
    private static final byte[] ATR_PATTERN = new byte[]{59, -104, 0, 64, 0, 0, 0, 0, 1, 1, -83, 19, 16};
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, 0, 0, 0, 0, -1, -1, -1, -1, -16};

    private PCSCUtils() {
        throw new UnsupportedOperationException();
    }

    public static void verifyPin(char[] pin) throws TechnicalConnectorException {
        try {
            ResponseAPDU responseApdu = PCSCUtils.verifyPIN(pin);
            if (36864 != responseApdu.getSW()) {
                LOG.debug("VERIFY_PIN error");
                LOG.debug("SW: " + Integer.toHexString(responseApdu.getSW()));
                if (27011 == responseApdu.getSW()) {
                    throw new BeIDPinCodeException(new ResponseAPDUException("eID card blocked!", responseApdu));
                }
                if (99 != responseApdu.getSW1()) {
                    LOG.debug("PIN verification error.");
                    throw new BeIDPinCodeException(new ResponseAPDUException("PIN Verification Error", responseApdu));
                }
                throw new BeIDPinCodeException(new ResponseAPDUException("PIN Verification Error", responseApdu));
            }
        }
        catch (CardNotPresentException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_EID_NULL, (Throwable)e, new Object[0]);
        }
        catch (CardException e) {
            throw new BeIDPinCodeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResponseAPDU verifyPIN(char[] pin) throws CardException {
        byte[] verifyData = new byte[]{(byte)(0x20 | pin.length), -1, -1, -1, -1, -1, -1, -1};
        for (int idx = 0; idx < pin.length; idx += 2) {
            byte value;
            char digit1 = pin[idx];
            int digit2 = idx + 1 < pin.length ? pin[idx + 1] : 63;
            verifyData[idx / 2 + 1] = value = (byte)((digit1 - 48 << 4) + (digit2 - 48));
        }
        Arrays.fill(pin, '\u0000');
        LOG.debug("verifying PIN...");
        try {
            ResponseAPDU responseAPDU = PCSCUtils.transmit(new CommandAPDU(0, 32, 0, 1, verifyData));
            return responseAPDU;
        }
        finally {
            Arrays.fill(verifyData, (byte)0);
        }
    }

    private static ResponseAPDU transmit(CommandAPDU commandApdu) throws CardException {
        CardTerminal terminal;
        TerminalFactory factory = TerminalFactory.getDefault();
        List<CardTerminal> terminals = factory.terminals().list();
        LOG.debug("Terminals: " + terminals);
        Card card = null;
        Iterator<CardTerminal> i$ = terminals.iterator();
        while (!(!i$.hasNext() || (terminal = i$.next()).isCardPresent() && (card = terminal.connect("*")) != null && PCSCUtils.matchesEidAtr(card.getATR()))) {
        }
        if (card == null) {
            throw new CardNotPresentException("EID is not present");
        }
        card.beginExclusive();
        LOG.debug("card: " + card);
        CardChannel cardChannel = card.getBasicChannel();
        ResponseAPDU responseApdu = cardChannel.transmit(commandApdu);
        if (108 == responseApdu.getSW1()) {
            LOG.debug("sleeping...");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new be.ehealth.technicalconnector.exception.InterruptedException("Cannot sleep", e);
            }
            responseApdu = cardChannel.transmit(commandApdu);
        }
        card.endExclusive();
        card.disconnect(false);
        return responseApdu;
    }

    private static boolean matchesEidAtr(ATR atr) {
        byte[] atrBytes = atr.getBytes();
        if (atrBytes.length != ATR_PATTERN.length) {
            return false;
        }
        for (int idx = 0; idx < atrBytes.length; ++idx) {
            int n = idx;
            atrBytes[n] = (byte)(atrBytes[n] & ATR_MASK[idx]);
        }
        return Arrays.equals(atrBytes, ATR_PATTERN);
    }
}

