/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.status;

import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.status.CMSErrorType;

public enum NotificationFatal {
    ENVELOPED_DATA_STRUCTURE_INCORRECT,
    DECRYPTION_PRIVATE_KEY_NOT_FOUND,
    OUTER_SIGNED_DATA_CONTENT_STRUCTURE_INVALID,
    SECRET_KEY_CAN_NOT_DECRYPT_KEKRECIPIENTINFOS,
    ENVELOPED_DATA_CONTAINS_NO_KEYTRANSRECIPIENTINFOS,
    ENVELOPED_DATA_CONTAINS_NO_KEKRECIPIENTINFOS,
    CERTIFICATION_PATH_CHECK_FAILED,
    CRL_CHECK_FAILED,
    OCSP_CHECK_FAILED,
    STAMP_FAILED,
    MESSAGE_INNER_SIGNED_PART_HAS_NO_SIGNER_INFORMATION(CMSErrorType.NO_SIGNER_INFOS.getMsg(), SignatureLayer.INNER),
    MESSAGE_OUTER_SIGNED_PART_HAS_NO_SIGNER_INFORMATION(CMSErrorType.NO_SIGNER_INFOS.getMsg(), SignatureLayer.OUTER),
    MESSAGE_INNER_SIGNED_PART_HAS_MORE_THAN_ONE_SIGNER_INFORMATION(CMSErrorType.MORE_THAN_1_SIGNER_INFO.getMsg(), SignatureLayer.INNER),
    MESSAGE_OUTER_SIGNED_PART_HAS_MORE_THAN_ONE_SIGNER_INFORMATION(CMSErrorType.MORE_THAN_1_SIGNER_INFO.getMsg(), SignatureLayer.OUTER),
    INNER_SIGNED_DATA_STRUCTURE_INCORRECT(CMSErrorType.PARSE_ERROR.getMsg(), SignatureLayer.INNER),
    OUTER_SIGNED_DATA_STRUCTURE_INCORRECT(CMSErrorType.PARSE_ERROR.getMsg(), SignatureLayer.OUTER),
    INNER_SIGNED_DATA_CONTENT_MISSING(CMSErrorType.CONTENT_MISSING.getMsg(), SignatureLayer.INNER),
    OUTER_SIGNED_DATA_CONTENT_MISSING(CMSErrorType.CONTENT_MISSING.getMsg(), SignatureLayer.OUTER),
    MESSAGE_INNER_SIGNED_PART_CONTAINS_INCORRECTLY_ENCODED_CERTIFICATES_SET(CMSErrorType.INCORRECTLY_ENCODED_CERTIFICATES.getMsg(), SignatureLayer.INNER),
    MESSAGE_OUTER_SIGNED_PART_CONTAINS_INCORRECTLY_ENCODED_CERTIFICATES_SET(CMSErrorType.INCORRECTLY_ENCODED_CERTIFICATES.getMsg(), SignatureLayer.OUTER);

    private String errorMessage;
    private SignatureLayer signatureLayer;

    private NotificationFatal() {
    }

    private NotificationFatal(String errorMessage, SignatureLayer signatureLayer) {
        this.errorMessage = errorMessage;
        this.signatureLayer = signatureLayer;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static NotificationFatal getOuterFailureForMessage(String errorMessage) {
        for (NotificationFatal value : NotificationFatal.values()) {
            if (!SignatureLayer.OUTER.equals((Object)value.signatureLayer) || !value.getErrorMessage().equals(errorMessage)) continue;
            return value;
        }
        return null;
    }

    public static NotificationFatal getInnerFailureForMessage(String errorMessage) {
        for (NotificationFatal value : NotificationFatal.values()) {
            if (!SignatureLayer.INNER.equals((Object)value.signatureLayer) || !value.getErrorMessage().equals(errorMessage)) continue;
            return value;
        }
        return null;
    }
}

