package be.ehealth.technicalconnector.utils;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author EHP
 */
public class ConnectorXmlUtilsTest {

    @Test
    public void isXMLOneliner(){
       Assert.assertTrue(ConnectorXmlUtils.isXMLLike("<boe/>"));
    }

    @Test
    public void isXML(){
        Assert.assertTrue(ConnectorXmlUtils.isXMLLike("<boe>\n\ttest\n</boe>"));
    }

    @Test
    public void isXMLWithProcessInstruction(){
        Assert.assertTrue(ConnectorXmlUtils.isXMLLike("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><boe>\ntest\n</boe>"));
    }

    @Test
    public void isNotXML(){
        Assert.assertFalse(ConnectorXmlUtils.isXMLLike("test"));
    }


}